/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfView;

import com.ibm.xml.parser.TXElement;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Attr;

/*
 * @version Revision: 71 1.3 samples/CdfView/XMLComponentM.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp>
 */
public abstract class XMLComponentM extends TXElement implements MouseListener {
    
    URL m_url = null;
    Panel m_p = null;
    String m_title;

    public XMLComponentM(String qname) {
        super(qname);
    }

    public void ripen() {
        try {
            Attr attr = this.getAttributeNode("href");
            String u = null == attr ? "" : attr.getValue();
            if (attr == null) {
            } else if (u.toLowerCase().startsWith("http://")) { // Absolute URL
                this.m_url = new URL(u);
            } else {                            // Relative URL
                Node par = this;
                String base = null;
                while (null != (par = par.getParentNode())
                       && par.getNodeType() == Node.ELEMENT_NODE) {
                    Element el = (Element)par;
                    Attr baseAttr = el.getAttributeNode("BASE");
                    base = null == baseAttr ? "" : baseAttr.getValue();              
                    if (null != baseAttr)
                        break;
                }
                m_url = new URL(new URL(base), u);
            }
        } catch (Exception e) {
            System.err.println("XMLComponentM#ripen(): "+e.toString()+" at "+this.toString());
        }
        TXElement el = this.getElementNamed("TITLE");
        m_title = null == el ? (null == m_url ? null : m_url.toString()) : el.getText();
        if (null == m_title)  m_title = "*No Title*";
    }

    Gateway m_gate;
    public void setGateway(Gateway g) {
        this.m_gate = g;
        for (Node n = this.getFirstChild();  n != null;
             n = n.getNextSibling()) {
            if (n instanceof XMLComponentM)
                ((XMLComponentM)n).setGateway(g);
        }
    }

    public abstract int getConnectedOffset();

    public java.awt.Container getContainer() {
        return this.m_p;
    }

    boolean m_selected = false;
    public void select(boolean f) {
        this.m_selected = f;
    }

    public void mouseClicked(MouseEvent e) {
    }
    public void mousePressed(MouseEvent e) {
    }
    public void mouseReleased(MouseEvent e) {
    }
    public void mouseEntered(MouseEvent e) {
        if (null != m_url) {
            this.m_gate.setText(m_url.toString());
        }
    }
    public void mouseExited(MouseEvent e) {
        if (null != m_url) {
            this.m_gate.setText("");
        }
    }
}
