/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * A sample for element/attribute name alias.
 *
 * @version Revision: 72 1.2 samples/Miscellaneous/Alias.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class Alias extends TXDocument {
    public static void main(String[] argv) {
        if (2 != argv.length) {
            System.err.println("Alias <aliasfile> <targetxml>");
            return;
        }
        try {
            Alias alias = new Alias(argv[0]);
            String fname = argv[1];
            Parser p = new Parser(fname);
            p.setElementFactory(alias);
            TXDocument doc = p.readStream(p.getInputStream(fname, null, Stderr.file2URL(fname).toString()));
            doc.print(new OutputStreamWriter(System.out));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Hashtable elementalias = new Hashtable();
    protected Hashtable attributealias = new Hashtable();

    public Alias(String aliasdata) throws IOException {
        Parser p = new Parser(aliasdata);
        TXDocument doc = p.readStream(p.getInputStream(aliasdata, null, Stderr.file2URL(aliasdata).toString()));
        if (0 == p.getNumberOfErrors()) {
            Enumeration en = ((TXElement)doc.getDocumentElement()).elements();
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (obj instanceof TXElement) {
                    TXElement el = (TXElement)obj;
                    if (el.getNodeName().equals("ALIAS")) {
                        this.elementalias.put(el.getAttribute("as"), el.getAttribute("real"));
                    } else if (el.getNodeName().equals("AALIAS")) {
                        this.attributealias.put(el.getAttribute("as"), el.getAttribute("real"));
                    } else {
                        System.err.println("An alias file has bad structure.");
                    }
                }
            }
        }
    }

    public Element createElement(String name) {
        String realname = (String)elementalias.get(name);
        if (realname != null)  name = realname;
        return super.createElement(name);
    }

    public Attr createAttribute(String name) {
        String realname = (String)attributealias.get(name);
        if (realname != null)  name = realname;
        return super.createAttribute(name);
    }
}

