/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.Util;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * A sample of MD5.
 *
 * @version Revision: 73 1.1 samples/Miscellaneous/Digest.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class Digest {
    public static void main(String[] argv) {
        TXDocument doc = new TXDocument();
        doc.setVersion("1.0");

        Element root = doc.createElement("PERSON");

                                                //  Make <NAME>John Doe</NAME>
        Element item = doc.createElement("NAME");
        item.appendChild(doc.createTextNode("John Doe"));
        root.appendChild(item);
                                                // Make <AGE>35</AGE>
        item = doc.createElement("AGE");
        item.appendChild(doc.createTextNode("35"));
        root.appendChild(item);
                                                // Make <EMAIL>John.Doe@foo.com</EMAIL>
        item = doc.createElement("EMAIL");
        item.appendChild(doc.createTextNode("John.Doe@foo.com"));
        root.appendChild(item);
                                                // Make <URL HREF="http:...."/>
        item = doc.createElement("URL");
        item.setAttribute("HREF", "http://www.foo.com/%7EJohn.Doe/");
        root.appendChild(item);

                                                // Now root has NAME,AGE,EMAIL,URL.
        doc.appendChild(root);

        try {
            PrintWriter out = new PrintWriter(System.out);
            doc.printWithFormat(out);
            out.println("================================================================");
            printMD5Tree(doc, out, 0);

            out.println("================================================================");
            item.appendChild(doc.createTextNode("hoge?")); // Modify the document
            doc.printWithFormat(out);
            out.println("================================================================");
            printMD5Tree(doc, out, 0);
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void printByteArray(PrintWriter pw, byte[] ab) {
        if (null == ab) {
            pw.print("NULL");
        } else {
            for (int i = 0;  i < ab.length;  i ++) {
                printByte(pw, ab[i]);
            }
        }
        pw.println("");
    }
    static final String tab = "0123456789ABCDEF";
    static void printByte(PrintWriter pw, byte b) {
        
        pw.print(tab.charAt((b>>4)&0x0f));
        pw.print(tab.charAt(b&0x0f));
    }
    static void printMD5Tree(Parent par, PrintWriter pw, int indent) throws IOException {
        for (Node ch = par.getFirstChild();  ch != null;  ch = ch.getNextSibling()) {
            Util.printSpace(pw, indent);
            pw.print(samples.XJParse.XJParse.getLastName(ch.getClass().toString())+" ");
            printByteArray(pw, ((Child)ch).getDigest());
            if (ch instanceof Parent) {
                printMD5Tree((Parent)ch, pw, indent+2);
            }
        }
        pw.flush();
    }
}

