/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.NonRecursivePreorderTreeTraversal;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.util.HTMLPrintVisitor;
import java.io.OutputStreamWriter;
import java.io.Writer;

/**
 * A sample for HTML-like printing.
 *
 * @version Revision: 75 1.1 samples/Miscellaneous/HTMLPrint.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.util.HTMLPrintVisitor
 */
public class HTMLPrint {
    public static void main(String[] argv) {
        try {
            String fname = argv[0];
            Parser p = new Parser(fname);
            TXDocument doc = p.readStream(p.getInputStream(fname, null, Stderr.file2URL(fname).toString()));

            Writer wr = new OutputStreamWriter(System.out);
            new NonRecursivePreorderTreeTraversal(new HTMLPrintVisitor(wr)).traverse(doc);
            wr.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
