/*
 * (C) Copyright IBM Corp. 1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.Util;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * Dump expanded name for elements and attributes.
 *
 * @version Revision: 56 1.1 samples/Miscellaneous/NamespaceDump.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class NamespaceDump {
    public static void printExpandedNames(Parent par, PrintWriter pw, int indent) throws IOException {
        for (Node ch = par.getFirstChild();
             ch != null;  ch = ch.getNextSibling()) {
            if (ch.getNodeType() == Node.ELEMENT_NODE) {
                Util.printSpace(pw, indent);
                pw.println("ELEMENT: "+((TXElement)ch).createExpandedName());
                NamedNodeMap nnm = ch.getAttributes();
                for (int i = 0;  i < nnm.getLength();  i ++) {
                    Util.printSpace(pw, indent+2);
                    pw.println("ATTRIBUTE: "+((TXAttribute)nnm.item(i)).createExpandedName());
                }
            }
            if (ch instanceof Parent) {
                printExpandedNames((Parent)ch, pw, indent+4);
            }
        }
        pw.flush();
    }

    public static void main(String[] argv) {
        try {
            String fname = argv[0];
            Parser p = new Parser(fname);
            p.setProcessNamespace(true);
            TXDocument doc = p.readStream(p.getInputStream(fname, null, Stderr.file2URL(fname).toString()));
            printExpandedNames(doc, new PrintWriter(System.out), 0);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

