/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TagHandler;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.w3c.dom.Document;

/**
 * A sample to display a progress(?) bar while parsing.
 * This programs requires JDK 1.2 or JDK 1.1+Swing-1.1.
 *
 * @version Revision: 78 1.2 samples/Miscellaneous/Progress.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class Progress implements TagHandler {
    public static void main(String[] argv) {
        if (1 != argv.length) {
            System.err.println("Require 1 filename.");
            System.exit(1);
        }
        try {
            Progress prog = new Progress(argv[0]);
            String fname = argv[0];
            Parser parser = new Parser(fname);
            parser.setTagHandler(prog);
            Document doc = parser.readStream(parser.getInputStream(fname, null, Stderr.file2URL(fname).toString()));

            if (parser.getNumberOfErrors() > 0) {
                System.exit(1);
            }
            System.exit(0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    static final int LIMIT = 32;
    int depth = 0;
    int count = 0;
    JProgressBar progress;
    JTextField label;
    Graphics progressg, labelg;

    Progress(String fname) {
        Frame f = new Frame("Parsing: "+fname);
        this.progress = new JProgressBar();
        this.progress.setMinimum(0);
        this.progress.setMaximum(LIMIT-1);
        this.label = new JTextField("0");
        f.add(this.label, "North");
        f.add(this.progress, "Center");
        f.pack();
        f.setSize(384, 80);
        Dimension di = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation((di.width-384)/2, (di.height-80)/2);
        f.show();

        this.progressg = this.progress.getGraphics();
        this.labelg = this.label.getGraphics();
    }

                                                // parser.TagHandler
    public void handleStartTag(TXElement el, boolean empty) {
        this.depth ++;
        this.count ++;
        this.progress.setValue(this.depth % LIMIT);
        this.label.setText(Integer.toString(this.count));
        //this.progress.update(this.progressg);
        //this.label.update(this.labelg);
        //this.progress.repaint(0L);
    }

                                                // parser.TagHandler
    public void handleEndTag(TXElement el, boolean empty) {
        this.depth --;
        this.progress.setValue(this.depth % LIMIT);
        //this.progress.update(this.progress.getGraphics());
        //this.progress.repaint(0L);
    }
}
