/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

/*
 * SampleFilter: Convert <email>foo@bar</email> to <url href="mailto:foo@bar"/>
 *
 * @version Revision: 79 1.1 samples/Miscellaneous/SampleFilter.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 *  Try:   java SampleFilter -print personal.xml
 */

import com.ibm.xml.parser.*;
import java.io.*;

public class SampleFilter implements ElementHandler {
    public TXElement handleElement(TXElement el) { // ElementHandler
        String addr;
        if (0 != (addr = el.getText()).length()) {
            TXElement e = new TXElement("URL");
            e.setAttribute("HREF", "mailto:"+addr);
            el = e;
        } 
        return el;
    }

    public static void main(String[] argv) {
        try {
            String fname = null;
            boolean isprint = false;
            for (int i = 0;  i < argv.length;  i ++) {
                if ('-' != argv[i].charAt(0)) {
                    fname = argv[i];
                } else if ("-print".equals(argv[i])) {
                    isprint = true;
                } else {
                    System.err.println("Warning: Unknown option: "+argv[i]);
                }
            }

            Parser pc = new Parser(fname);

            // ================================================
            pc.addElementHandler(new SampleFilter(), "EMAIL");
            // ================================================
            TXDocument doc = pc.readStream(pc.getInputStream(fname, null, fname));
            if (isprint) {
                doc.print(new PrintWriter(new OutputStreamWriter(System.out)));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
