/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

/*
 * SampleFilter2: Show <name> element
 *
 * @version Revision: 80 1.1 samples/Miscellaneous/SampleFilter2.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 *  Try:   java SampleFilter2 -print personal.xml
 */

import com.ibm.xml.parser.*;
import java.io.*;
import java.util.*;

public class SampleFilter2 implements ElementHandler {

    Vector m_names = new Vector();
    public TXElement handleElement(TXElement el) { // ElementHandler
        m_names.addElement(el);
        return el;
    }

    void print() {
        for (Enumeration en = m_names.elements();  en.hasMoreElements();  ) {
            TXElement el = (TXElement)en.nextElement();
            System.out.println(el.getText());
        }
    }

    public static void main(String[] argv) {
        try {
            String fname = null;
            boolean isprint = false;
            for (int i = 0;  i < argv.length;  i ++) {
                if ('-' != argv[i].charAt(0)) {
                    fname = argv[i];
                } else if ("-print".equals(argv[i])) {
                    isprint = true;
                } else {
                    System.err.println("Warning: Unknown option: "+argv[i]);
                }
            }

            Parser pc = new Parser(fname);

            // ================================================
            SampleFilter2 sf = new SampleFilter2();
            pc.addElementHandler(sf, "NAME");
            // ================================================

            TXDocument doc = pc.readStream(pc.getInputStream(fname, null, fname));
            if (isprint) {
                doc.print(new PrintWriter(new OutputStreamWriter(System.out)));
            }

            // ================================================
            sf.print();
            // ================================================

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
