/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.*;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;

/**
 * A sample for Serialize.
 *
 * @version Revision: 82 1.1 samples/Miscellaneous/SerializeSave.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class SerializeSave {
    public static void main(String[] argv) {
        try {
            String fname = argv[0];
            Parser p = new Parser(fname);
            TXDocument doc = p.readStream(p.getInputStream(fname, null, Stderr.file2URL(fname).toString()));

            OutputStream os = new FileOutputStream("xml.ser");
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(doc);
            oos.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
