/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.CMLeaf;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ExternalID;
import com.ibm.xml.parser.PseudoNode;
import com.ibm.xml.parser.TXDocument;
import java.io.PrintWriter;
import org.w3c.dom.Element;

/**
 *
 * @version Revision: 83 1.1 samples/Miscellaneous/SimpleGen.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class SimpleGen {
    public static void main(String[] argv) {
        try {
            TXDocument doc = new TXDocument();
            doc.setVersion("1.0");
            DTD dtd = doc.createDTD("ROOT", null);
                                        // Make <!ENTITY chapter1 SYSTEM "chap1.ent">
            dtd.appendChild(doc.createEntityDecl("chapter1", new ExternalID("chap1.ent"), false, null));
                                        // Make <!ELEMENT ROOT (#PCDATA)>
            dtd.appendChild(doc.createElementDecl("ROOT", doc.createContentModel(new CMLeaf("#PCDATA"))));
            doc.appendChild(dtd);

            Element root = doc.createElement("ROOT");
            root.appendChild(doc.createEntityReference("chapter1"));
            doc.appendChild(root);

            doc.printWithFormat(new PrintWriter(System.out));

            System.out.println("================================================================");
                                                // Another way
            doc = new TXDocument();
            doc.setVersion("1.0");
            dtd = doc.createDTD("ROOT", null);
            dtd.appendChild(new PseudoNode("<!ENTITY chapter1 SYSTEM \"chap1.ent\">"));
            dtd.appendChild(new PseudoNode("<!ELEMENT ROOT (#PCDATA)>"));
            doc.appendChild(dtd);
            root = doc.createElement("ROOT");
            root.appendChild(new PseudoNode("&chapter1;"));
            doc.appendChild(root);

            doc.printWithFormat(new PrintWriter(System.out));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
