/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.util.TreeFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

/**
 *
 * @version Revision: 53 1.1 samples/Miscellaneous/TreeViewHelper.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class TreeViewHelper extends JFrame {
    public static void main(String[] argv) {
        if (1 != argv.length) {
            System.err.println("Require 1 filename");
            System.exit(1);
        }
        String fname = argv[0];
        try {
            Parser p = new Parser(fname);
            p.setElementFactory(new TreeFactory());
            new TreeViewHelper("XML Tree View", (TreeNode)p.readStream(p.getInputStream(fname, null, Stderr.file2URL(fname).toString()))).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public TreeViewHelper(String title, TreeNode root) {
        super(title);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent e) {
                System.exit(0);
            }
        });
        getContentPane().add(new JScrollPane(new JTree(root))); 
        setSize(320, 480);
    }
}
