/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.Miscellaneous;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Source;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXComment;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.util.TreeFactory;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/**
 *
 * @version Revision: 85 1.3 samples/Miscellaneous/ViewDigest.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class ViewDigest extends JFrame {
    public static void main(String[] argv) {
        if (1 != argv.length) {
            System.err.println("Specify `personal.xml'");
            System.exit(1);
        }
        String fname = argv[0];
        try {
            Parser p = new Parser(fname);
            p.setElementFactory(new DTFactory());
            Source src = p.getInputStream(fname, null, Stderr.file2URL(fname).toString());
            System.err.print("Parsing ... ");  System.err.flush();
            TXDocument doc = p.readStream(src);
            System.err.println("done.");
            new ViewDigest("XML Digest View", doc).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ViewDigest(String tit, TXDocument doc) {
        super(tit);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent e) {
                System.exit(0);
            }
        });
        Container cont = getContentPane();
        cont.setLayout(new GridLayout(2, 2));

        System.err.print("Create Tree ... ");  System.err.flush();
        JTree tree1 = new JTree((TreeNode)doc);
        System.err.println("done.");
        System.err.print("Create TextArea ... ");  System.err.flush();
        StringWriter sw = new StringWriter();
        try {
            doc.print(sw);
            sw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        JTextArea tarea1 = new JTextArea(sw.toString());
        System.err.println("done.");
            

        System.err.print("Cloning document ... ");  System.err.flush();
        TXDocument doc2 = (TXDocument)doc.clone();
        System.err.println("done.");

        System.err.print("Modify document: 3rd <person> - 1st <url> ... ");  System.err.flush();
        TXElement el = (TXElement)doc2.getDocumentElement();
        el = el.getNthElementNamed(2, "person");
        el = el.getElementNamed("url");
        el.setAttribute("href", "http://w3.trl.ibm.com/%7Ekent/");

        System.err.print("Create Tree ... ");  System.err.flush();
        JTree tree2 = new JTree((TreeNode)doc2);
        System.err.println("done.");

        System.err.print("Create TextArea ... ");  System.err.flush();
        sw = new StringWriter();
        try {
            doc2.print(sw);
        } catch (IOException e) {
            e.printStackTrace();
        }
        JTextArea tarea2 = new JTextArea(sw.toString());
        System.err.println("done.");

        cont.add(new JScrollPane(tarea1));
        cont.add(new JScrollPane(tarea2));
        cont.add(new JScrollPane(tree1));
        cont.add(new JScrollPane(tree2));
        Font f = tree1.getFont();
        tree1.setFont(f = new Font("monospaced", Font.PLAIN, f.getSize()+1));
        tarea1.setFont(f);
        tree2.setFont(f);
        tarea2.setFont(f);
        
        for (int i = 0;  i < tree1.getRowCount();  i ++) {
            tree1.expandRow(i);
        }
        for (int i = 0;  i < tree2.getRowCount();  i ++) {
            tree2.expandRow(i);
        }
        setSize(640, 480);
    }

    public static class DTFactory extends TreeFactory {
        static String printByteArray(byte[] ab) {
            StringBuffer sb = new StringBuffer(32);
            if (null == ab) {
                sb.append("NULL");
            } else {
                for (int i = 0;  i < ab.length;  i ++) {
                    printByte(sb, ab[i]);
                }
            }
            return sb.toString();
        }
        static final String tab = "0123456789ABCDEF";
        static void printByte(StringBuffer sb, byte b) {
            sb.append(tab.charAt((b>>4)&0x0f));
            sb.append(tab.charAt(b&0x0f));
        }

        public DTFactory() {
            super();
        }
        public String toStringComment(Comment com, String encoding) {
            TXComment tc = (TXComment)com;
            return printByteArray(tc.getDigest())+" <!--"+com.getData()+"-->";
        }
        public String toStringElement(TXElement el, String encoding) {
            return printByteArray(el.getDigest())+" <"+el.getNodeName()+">";
        }
        public String toStringPI(ProcessingInstruction pi, String encoding) {
            return printByteArray(((TXPI)pi).getDigest())+" <?"+pi.getTarget()+" ... ?>";
        }
        public String toStringText(Text text, String encoding) {
            String ret;
            if (text instanceof CDATASection) {
                ret = printByteArray(((TXText)text).getDigest())+" <![CDATA["+text.getData()+"]]>";
            } else {
                ret = printByteArray(((TXText)text).getDigest())+" \""+TXText.makePrintable(text.getData())+"\"";
            }
            return ret;
        }
    
    }

}

