/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
package samples.ProGuide;
import com.ibm.xml.parser.*;
import java.io.*;

// AElementHandler handles an Element and doesn't Filter it
class AElementHandler implements ElementHandler {
    public TXElement handleElement(TXElement el) {
        System.out.println("handling:"+el.getNodeName());
        return el;
    }
}

// FilterElementHandler handles an Element and Filters LINE elements...
class FilterElementHandler implements ElementHandler {
    public TXElement handleElement(TXElement el) {
        System.out.println("handling:"+el.getNodeName());
        if (el.getNodeName().equals("LINE"))
            return null;
        else
            return el;
    }
}
/**
 * This class shows the various things learned in
 * Programming Guide - guide.html, under the section
 *
 * How to get a filtered Parse Tree.
 *
 * This is to verify the code snippets for accuracy with
 * the latest DOM.
 * 
 * @version Revision: 57 1.2 samples/ProGuide/ElementHandlers.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Pfeiffer Ralf &lt;rpfeiffe@us.ibm.com&gt;
 */
public class ElementHandlers {

    public static void main (String args[]) {
        String filename = null;
        if (args.length > 0) {
            filename = args[0];

            if (filename != null) {
            InputStream is;
            try {
                is = new FileInputStream(filename);
            } catch (FileNotFoundException fileNotFound) {
                System.err.println(fileNotFound);
                return;
            }
            Parser parser = new Parser(filename);
            //parser.addElementHandler(new AElementHandler(), "SPEECH");
            parser.addElementHandler(new FilterElementHandler());
            TXDocument doc = parser.readStream(is);
            //*** Output Document as XML
            String charset = "ISO-8859-1";    // MIME charset name
            String jencode = MIME2Java.convert(charset);
            PrintWriter pw;
            try {
                pw = new PrintWriter(new OutputStreamWriter(System.out, jencode));
            } catch (UnsupportedEncodingException unsupported) {
                System.err.println(unsupported);
                return;
            }
            doc.setEncoding(charset);
            try {
                doc.print(pw, jencode);
            } catch (IOException io) {
                System.err.println(io);
                return;
                
            }
            }
        }
    }
}
