/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
package samples.ProGuide;
import com.ibm.xml.parser.*;
import java.io.*;
import java.awt.TextArea;
import java.awt.Frame;

class ErrorIgnorer implements ErrorListener {
    public int error(String fname, int lineno,
                      int charoff, Object key, String mes) {
        // do nothing
        return 1;
    }
}

class ErrorEater extends TextArea implements ErrorListener {

    public int error(String fname, int lineno,
                    int charoff, Object key, String mes) {
        append( fname+":"+lineno+":"+mes+"\n");
        return 1;
    }
}

/**
 * This class shows the various things learned in
 * Programming Guide - guide.html, under the section
 *
 * How to get the Parse Tree and capture errors.
 *
 * This is to verify the code snippets for accuracy with
 * the latest DOM.
 * 
 * @version Revision: 58 1.2 samples/ProGuide/GetParseTreeAndErrors.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Pfeiffer Ralf &lt;rpfeiffe@us.ibm.com&gt;
 */
public class GetParseTreeAndErrors {

    public static void main (String args[]) {

        String filename = null;
        if (args.length > 0) {
            filename = args[0];

            if (filename != null) {
                InputStream is;
                try {
                    is = new FileInputStream(filename);
                } catch (FileNotFoundException notFound) {
                    System.err.println(notFound);
                    return;
                }

                //*** Parser uses ErrorEater TextArea class
                ErrorEater ee = new ErrorEater();
                // Set up a Frame to show our lovely ErrorEater.
                Frame f = new Frame();
                // allows us to close the frame with the mouse.
                f.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });

                f.setSize(400,300);
                f.add("Center", ee);
                f.show();

                //*** Here is  the usage of our ErrorEater...
                Parser parser = new Parser(filename, ee, null);
                //*** Set some Parse options...
                parser.setWarningNoDoctypeDecl(false);
                parser.setWarningNoXMLDecl(false);
                parser.setPreserveSpace(false);
                parser.setKeepComment(false);
                //*** Get the parse tree
                TXDocument doc = parser.readStream(is);

                //*** Output Document as XML
                String charset = "ISO-8859-1";    // MIME charset name
                String jencode = MIME2Java.convert(charset);
                PrintWriter pw;
                try {
                    pw = new PrintWriter(new OutputStreamWriter(System.out, jencode));
                } catch (UnsupportedEncodingException unsupported) {
                    System.err.println(unsupported);
                    return;
                }
                doc.setEncoding(charset);
                try {
                    doc.print(pw, jencode);
                } catch (IOException io) {
                    System.err.println(io);
                    return;

                }
            }
        }
    }
}
