/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
package samples.ProGuide;
import com.ibm.xml.parser.*;
import java.io.*;
import java.awt.TextArea;
import java.awt.Frame;

// for ParseTree example...
import java.util.Enumeration;
import org.w3c.dom.*;

/**
 * This class shows the various things learned in
 * Programming Guide - guide.html, under the section
 *
 * How to traverse the Parse Tree.
 *
 * This is to verify the code snippets for accuracy with
 * the latest DOM.
 * 
 * @version Revision: 60 1.2 samples/ProGuide/ParseTree.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Pfeiffer Ralf &lt;rpfeiffe@us.ibm.com&gt;
 */
public class ParseTree {
    
    //*** Only refer to DOM Interfaces...
    public static void traverseDOMBranch(Node node) {
        // do what you want with this node here...
        System.out.println(node.getNodeName()+":"+node.getNodeValue());
        
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int size = nl.getLength();
            for (int i = 0; i < size; i++) {
                traverseDOMBranch(nl.item(i));
            }
        }
    }

    //*** Refer to TX classes...
    public static void traverseTX(Node node) {
        // do what you want with this node here...
        if (node instanceof TXElement) {
            TXElement el = (TXElement)node;
            // Do fancy TXElement stuff here...
            System.out.println(node.getNodeName()+":"+node.getNodeValue());
        } else if (node instanceof TXText) {
            TXText te = (TXText)node;
            // Do fancy TXText stuff here...
            System.out.println(node.getNodeName()+":"+node.getNodeValue());
        } 

        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int size = nl.getLength();
            for (int i = 0; i < size; i++) {
                traverseTX(nl.item(i));
            }
        }
    }
    
    public static void main (String args[]) {

        String filename = null;
        if (args.length > 0) {
            filename = args[0];

            if (filename != null) {
                InputStream is;
                try {
                    is = new FileInputStream(filename);
                } catch (FileNotFoundException notFound) {
                    System.err.println(notFound);
                    return;
                }

                Parser parser = new Parser(filename);
                
                //*** Note how we refer only to DOM Interface references.
                Document doc = parser.readStream(is);

                Element root = (Element)doc.getDocumentElement();
                //*** Use DOM Interface references.
                traverseDOMBranch(root);
                //*** Use TX classes.
                //traverseTX(root);

            }
        }
    }
}
