/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

/*
 * Revision: 89 1.2 samples/SiteOutliner/SiteOutlinerUI.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 */

package samples.SiteOutliner;

import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public class SiteOutlinerUI extends Dialog implements ItemListener, WindowListener {

  // parent frame
  private Frame frame = null;

  // constituents of top-level dialog
  private TextField ivjRootDirectoryField = null;
  private TextField ivjDocumentBaseURLField = null;
  private TextField ivjFileTypesField = null;
  private TextField ivjExcludingField = null;
  private TextField ivjNewerThanField = null;
  private TextField ivjSearchDepthField = null;

  private Button ivjFileTypesDialogButton = null;
  private Button ivjExcludingDialogButton = null;
  private Button ivjNewerThanDialogButton = null;
  private Button ivjDoItButton = null;
  private Button ivjCancelButton = null;

  // File Type Entry dialog
  private Dialog ivjFileTypeEntryDialog = null;
  private Button ivjFileTypeAddButton = null;
  private TextField ivjFileTypeEntryField = null;
  private List ivjFileTypeList = null;
  private Button ivjFileTypeOkButton = null;
  private Button ivjFileTypeRemoveButton = null;

  // Excluding dialog
  private Dialog ivjExcludingEntryDialog = null;
  private Button ivjExcludingAddButton = null;
  private TextField ivjExcludingEntryField = null;
  private List ivjExcludingList = null;
  private Button ivjExcludingOkButton = null;
  private Button ivjExcludingRemoveButton = null;

  // New Than ... dialog
  private Dialog ivjNewerThanDialog = null;
  private CheckboxGroup ivjModifiedSinceCheckboxGroup = null;
  private Checkbox ivjSinceDateCheckBox = null;
  private Checkbox ivjSinceFileCheckBox = null;
  private TextField ivjSinceFileField = null;
  private TextField ivjSinceDateField = null;
  private Button ivjSinceFileButton = null;
  private Button ivjNewerThanDialogOkButton = null;
  private FileDialog ivjSinceFile = null;

  // Error dialog
  private Dialog errorDialog = null;
  private Button errorDialogOkButton = null;
  private Label errorDialogLabel = null;

  private java.io.File rootDir = null;
  private java.util.Date since = null;
  private int depth = 10;
  private boolean canceled = true;

  /**
    * Constructor
    */
  public SiteOutlinerUI(Frame frame) {
    super(frame);
    this.frame = frame;
    initialize();

    // set initial values
    // 1. Root Directory
    try {
      rootDir = new File(".");
      ivjRootDirectoryField.setText(rootDir.getCanonicalPath());
    } catch (Throwable e) {
    }

    // 2. Base URL
    try {
      ivjDocumentBaseURLField.setText("http://"+java.net.InetAddress.getLocalHost().getHostName());
    } catch (Throwable e) {
      System.err.println(e);
    }

    // 3. File type list
    getFileTypeList();
    ivjFileTypeList.add(".html");
    ivjFileTypeList.add(".htm");
    ivjFileTypeList.add(".HTML");
    ivjFileTypeList.add(".HTM");
    ivjFileTypesField.setText(concatList(ivjFileTypeList.getItems()));

    // 4. Excluding list
    getExcludingList();
    ivjExcludingField.setText(concatList(ivjExcludingList.getItems()));

    // 5. Since date
    since = new java.util.Date((new java.util.Date()).getTime() - 1000*60*60*24); // 24 hours before
    ivjNewerThanField.setText(java.text.DateFormat.getDateInstance().format(since));

    // 6. depth
    ivjSearchDepthField.setText(Integer.toString(depth));
    
  }

  /**
    * Returns starting directory for scan
    * @return File
    */
  public File getRootDir() {
    return rootDir;
  }

  /**
    * Returns since date
    * @return Date
    */
  public java.util.Date getSince() {
    return since;
  }

  /**
    * Returns document base URL
    * @return String
    */
  public String getDocumentBaseURL() {
    return getDocumentBaseURLField().getText();
  }

  public String[] getFileTypes() {
    return ivjFileTypeList.getItems();
  }

  public String[] getExcludingPathNames() {
    return ivjExcludingList.getItems();
  }

  public int getSearchDepth() {
    return depth;
  }

  public boolean canceled() {
    return canceled;
  }




  /**
    * conn27:  (NewerThanDialogOkButton.action.actionPerformed(ActionEvent) --> NewerThanDialog.dispose())
    * @param arg1 ActionEvent
    */
  private void conn27(ActionEvent arg1) {
    try {
      if (ivjSinceFileCheckBox.getState()) {
    // "Since File" is checked
    try {
      File f = new File(ivjSinceFileField.getText());
      since = new java.util.Date(f.lastModified());
    } catch (Throwable e) {
      error(e.toString());
      return;
    }
      } else if (ivjSinceDateCheckBox.getState()) {
    try {
      since = java.text.DateFormat.getDateInstance().parse(ivjSinceDateField.getText());
    } catch (java.text.ParseException e) {
      error(e.toString());
      return;
    }
      } else {
      }
      ivjNewerThanField.setText(java.text.DateFormat.getDateInstance().format(since));
      getNewerThanDialog().dispose();

    } catch (java.lang.Throwable ivjExc) {
      handleException(ivjExc);
    }
  }

  private void error(String msg) {
    errorDialogLabel.setText(msg);
    errorDialog.show();
    return;
  }

  /**
    * Execute the body of Siteoutliner
    */
  private void doIt() {
    URL url = null;
    try {
      url = new URL(getDocumentBaseURL());
    } catch (MalformedURLException e) {
      error("Illegal Base URL ");
      return;
    }
    try {
      rootDir = new File(getRootDirectoryField().getText());
      if (!rootDir.isDirectory()) throw new java.io.IOException();
    } catch (Throwable e) {
      error("Please specify Root Directory");
      return;
    }
    try {
      depth = Integer.parseInt(getSearchDepthField().getText());
    } catch (Throwable e) {
      error("Illegal search depth");
      return;
    }
    System.err.println("Base URL="+getDocumentBaseURL());
    System.err.println("Root Directory="+getRootDir());
    java.text.DateFormat dateFormat = java.text.DateFormat.getDateTimeInstance();
    System.err.println("Since Date="+dateFormat.format(getSince()));
    canceled = false;
    dispose();
    return;
  }



  // Top-level constituents
  /**
    * Return the RootDirectoryField property value.
    * @return TextField
    */
  private TextField getRootDirectoryField() {
    if (ivjRootDirectoryField == null) {
      try {
    ivjRootDirectoryField = new TextField();
    ivjRootDirectoryField.setName("RootDirectoryField");
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjRootDirectoryField;
  }

  /**
    * Return the DocumentBaseURLField property value.
    * @return TextField
    */
  private TextField getDocumentBaseURLField() {
    if (ivjDocumentBaseURLField == null) {
      try {
    ivjDocumentBaseURLField = new TextField();
    ivjDocumentBaseURLField.setName("DocumentBaseURLField");
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjDocumentBaseURLField;
  }

  /**
    * Return the FileTypesField property value.
    * @return TextField
    */
  private TextField getFileTypesField() {
    if (ivjFileTypesField == null) {
      try {
    ivjFileTypesField = new TextField();
    ivjFileTypesField.setName("FileTypesField");
    ivjFileTypesField.setBounds(169, 225, 269, 24);
    ivjFileTypesField.setEditable(false);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypesField;
  }

  /**
    * Return the ExcludingField property value.
    * @return TextField
    */
  private TextField getExcludingField() {
    if (ivjExcludingField == null) {
      try {
    ivjExcludingField = new TextField();
    ivjExcludingField.setName("ExcludingField");
    ivjExcludingField.setBounds(169, 225, 269, 24);
    ivjExcludingField.setEditable(false);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingField;
  }

  /**
    * Return the NewerThan property value.
    * @return TextField
    */
  private TextField getNewerThanField() {
    if (ivjNewerThanField == null) {
      try {
    ivjNewerThanField = new TextField();
    ivjNewerThanField.setName("NewerThanField");
    ivjNewerThanField.setEditable(false);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjNewerThanField;
  }

  /**
    * Return the SearchDepth property value.
    * @return TextField
    */
  private TextField getSearchDepthField() {
    if (ivjSearchDepthField == null) {
      try {
    ivjSearchDepthField = new TextField();
    ivjSearchDepthField.setName("SearchDepthField");
    ivjSearchDepthField.setEditable(true);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjSearchDepthField;
  }

  /**
    * Return the FileTypesDialogButton property value.
    * @return java.awt.Button
    */
  private java.awt.Button getFileTypeEntryDialogButton() {
    if (ivjFileTypesDialogButton == null) {
      try {
    ivjFileTypesDialogButton = new java.awt.Button();
    ivjFileTypesDialogButton.setName("FileTypesDialogButton");
    ivjFileTypesDialogButton.setBounds(452, 221, 67, 30);
    ivjFileTypesDialogButton.setLabel("Details ...");
    ivjFileTypesDialogButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getFileTypeEntryDialog().show();
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypesDialogButton;
  }

  /**
    * Return the ExcludingDialogButton property value.
    * @return java.awt.Button
    */
  private java.awt.Button getExcludingDialogButton() {
    if (ivjExcludingDialogButton == null) {
      try {
    ivjExcludingDialogButton = new java.awt.Button();
    ivjExcludingDialogButton.setName("ExcludingDialogButton");
    ivjExcludingDialogButton.setBounds(452, 221, 67, 30);
    ivjExcludingDialogButton.setLabel("Details ...");
    ivjExcludingDialogButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getExcludingEntryDialog().show();
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingDialogButton;
  }

  /**
    * Return the NewerThanDialogButton property value.
    * @return Button
    */
  private Button getNewerThanDialogButton() {
    if (ivjNewerThanDialogButton == null) {
      try {
    ivjNewerThanDialogButton = new Button();
    ivjNewerThanDialogButton.setName("NewerThanDialogButton");
    ivjNewerThanDialogButton.setLabel("Details ...");
    ivjNewerThanDialogButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getNewerThanDialog().show();
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjNewerThanDialogButton;
  }

  /**
    * Return the DoItButton property value.
    * @return Button
    */
  private Button getDoItButton() {
    if (ivjDoItButton == null) {
      try {
    ivjDoItButton = new Button();
    ivjDoItButton.setName("DoItButton");
    ivjDoItButton.setLabel("DoIt");
    ivjDoItButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        doIt();
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjDoItButton;
  }

  // File Type Entry Dialog
  /**
    * Return the FileTypesDialog property value.
    * @return Dialog
    */
  private Dialog getFileTypeEntryDialog() {
    if (ivjFileTypeEntryDialog == null) {
      try {
    ivjFileTypeEntryDialog = new Dialog(frame);
    ivjFileTypeEntryDialog.setName("FileTypesDialog");
    GridBagLayout gb = new GridBagLayout();
    GridBagConstraints gc = new GridBagConstraints();
    gc.insets = new Insets(3,3,3,3);
    ivjFileTypeEntryDialog.setLayout(gb);
    ivjFileTypeEntryDialog.setModal(true);
    ivjFileTypeEntryDialog.setBounds(421, 439, 426, 240);
    ivjFileTypeEntryDialog.setTitle("Enter file types to be included in CDF");
    gc.fill = GridBagConstraints.BOTH;
    gc.anchor = GridBagConstraints.EAST;
    mb(ivjFileTypeEntryDialog,0,0,1,1,getFileTypeEntryField(),gb,gc);
    mb(ivjFileTypeEntryDialog,0,1,1,3,getFileTypeList(),gb,gc);
    mb(ivjFileTypeEntryDialog,1,0,1,1,getFileTypeAddButton(), gb,gc);
    mb(ivjFileTypeEntryDialog,1,1,1,1,getFileTypeRemoveButton(), gb,gc);
    mb(ivjFileTypeEntryDialog,1,2,1,1,getFileTypeOkButton(), gb,gc);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypeEntryDialog;
  }

  /**
    * Return the FileTypeAddButton property value.
    * @return Button
    */
  private Button getFileTypeAddButton() {
    if (ivjFileTypeAddButton == null) {
      try {
    ivjFileTypeAddButton = new Button();
    ivjFileTypeAddButton.setName("FileTypeAddButton");
    ivjFileTypeAddButton.setBounds(264, 35, 125, 30);
    ivjFileTypeAddButton.setLabel("Add");
    ivjFileTypeAddButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getFileTypeList().addItem(getFileTypeEntryField().getText());
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypeAddButton;
  }

  /**
    * Return the FileTypeEntryField property value.
    * @return TextField
    */
  private TextField getFileTypeEntryField() {
    if (ivjFileTypeEntryField == null) {
      try {
    ivjFileTypeEntryField = new TextField();
    ivjFileTypeEntryField.setName("FileTypeEntryField");
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypeEntryField;
  }


  /**
    * Return the FileTypeList property value.
    * @return List
    */
  private List getFileTypeList() {
    if (ivjFileTypeList == null) {
      try {
    ivjFileTypeList = new List();
    ivjFileTypeList.setName("FileTypeList");
    ivjFileTypeList.setBounds(66, 86, 123, 125);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypeList;
  }


  /**
    * Return the FileTypeOkButton property value.
    * @return Button
    */
  private Button getFileTypeOkButton() {
    if (ivjFileTypeOkButton == null) {
      try {
    ivjFileTypeOkButton = new Button();
    ivjFileTypeOkButton.setName("FileTypeOkButton");
    ivjFileTypeOkButton.setLabel("Ok");
    ivjFileTypeOkButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getFileTypesField().setText(concatList(getFileTypeList().getItems()));
        getFileTypeEntryDialog().dispose();
      }
    });

      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypeOkButton;
  }

  /**
    * Return the FileTypeRemoveButton property value.
    * @return Button
    */
  private Button getFileTypeRemoveButton() {
    if (ivjFileTypeRemoveButton == null) {
      try {
    ivjFileTypeRemoveButton = new Button();
    ivjFileTypeRemoveButton.setName("FileTypeRemoveButton");
    ivjFileTypeRemoveButton.setBounds(267, 90, 125, 30);
    ivjFileTypeRemoveButton.setLabel("Remove");
    getFileTypeRemoveButton().addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (getFileTypeList().getSelectedItem()!=null) 
          getFileTypeList().remove(getFileTypeList().getSelectedItem());
      }
    });

      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjFileTypeRemoveButton;
  }


  // Excluding Entry Dialog
  /**
    * Return the ExcludingsDialog property value.
    * @return Dialog
    */
  private Dialog getExcludingEntryDialog() {
    if (ivjExcludingEntryDialog == null) {
      try {
    ivjExcludingEntryDialog = new Dialog(frame);
    ivjExcludingEntryDialog.setName("ExcludingsDialog");
    GridBagLayout gb = new GridBagLayout();
    GridBagConstraints gc = new GridBagConstraints();
    gc.insets = new Insets(3,3,3,3);
    ivjExcludingEntryDialog.setLayout(gb);
    ivjExcludingEntryDialog.setModal(true);
    ivjExcludingEntryDialog.setBounds(421, 439, 426, 240);
    ivjExcludingEntryDialog.setTitle("Enter file/directory names to be excluded");
    gc.fill = GridBagConstraints.BOTH;
    gc.anchor = GridBagConstraints.EAST;
    mb(ivjExcludingEntryDialog,0,0,1,1,getExcludingEntryField(),gb,gc);
    mb(ivjExcludingEntryDialog,0,1,1,3,getExcludingList(),gb,gc);
    mb(ivjExcludingEntryDialog,1,0,1,1,getExcludingAddButton(), gb,gc);
    mb(ivjExcludingEntryDialog,1,1,1,1,getExcludingRemoveButton(), gb,gc);
    mb(ivjExcludingEntryDialog,1,2,1,1,getExcludingOkButton(), gb,gc);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingEntryDialog;
  }

  /**
    * Return the ExcludingAddButton property value.
    * @return Button
    */
  private Button getExcludingAddButton() {
    if (ivjExcludingAddButton == null) {
      try {
    ivjExcludingAddButton = new Button();
    ivjExcludingAddButton.setName("ExcludingAddButton");
    ivjExcludingAddButton.setBounds(264, 35, 125, 30);
    ivjExcludingAddButton.setLabel("Add");
    ivjExcludingAddButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getExcludingList().addItem(getExcludingEntryField().getText());
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingAddButton;
  }

  /**
    * Return the ExcludingEntryField property value.
    * @return TextField
    */
  private TextField getExcludingEntryField() {
    if (ivjExcludingEntryField == null) {
      try {
    ivjExcludingEntryField = new TextField();
    ivjExcludingEntryField.setName("ExcludingEntryField");
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingEntryField;
  }


  /**
    * Return the ExcludingList property value.
    * @return List
    */
  private List getExcludingList() {
    if (ivjExcludingList == null) {
      try {
    ivjExcludingList = new List();
    ivjExcludingList.setName("ExcludingList");
    ivjExcludingList.setBounds(66, 86, 123, 125);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingList;
  }


  /**
    * Return the ExcludingOkButton property value.
    * @return Button
    */
  private Button getExcludingOkButton() {
    if (ivjExcludingOkButton == null) {
      try {
    ivjExcludingOkButton = new Button();
    ivjExcludingOkButton.setName("ExcludingOkButton");
    ivjExcludingOkButton.setLabel("Ok");
    ivjExcludingOkButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getExcludingField().setText(concatList(getExcludingList().getItems()));
        getExcludingEntryDialog().dispose();
      }
    });

      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingOkButton;
  }

  /**
    * Return the ExcludingRemoveButton property value.
    * @return Button
    */
  private Button getExcludingRemoveButton() {
    if (ivjExcludingRemoveButton == null) {
      try {
    ivjExcludingRemoveButton = new Button();
    ivjExcludingRemoveButton.setName("ExcludingRemoveButton");
    ivjExcludingRemoveButton.setBounds(267, 90, 125, 30);
    ivjExcludingRemoveButton.setLabel("Remove");
    getExcludingRemoveButton().addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if (getExcludingList().getSelectedItem()!=null) 
          getExcludingList().remove(getExcludingList().getSelectedItem());
      }
    });

      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjExcludingRemoveButton;
  }




  /**
    * Return the NewerThanDialogOkButton property value.
    * @return Button
    */
  private Button getNewerThanDialogOkButton() {
    if (ivjNewerThanDialogOkButton == null) {
      try {
    ivjNewerThanDialogOkButton = new Button();
    ivjNewerThanDialogOkButton.setName("NewerThanDialogOkButton");
    ivjNewerThanDialogOkButton.setBounds(305, 182, 81, 34);
    ivjNewerThanDialogOkButton.setLabel("Ok");
    ivjNewerThanDialogOkButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        conn27(e);
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjNewerThanDialogOkButton;
  }


  /**
    * Return the NewerThanDialog property value.
    * @return Dialog
    */
  private Dialog getNewerThanDialog() {
    if (ivjNewerThanDialog == null) {
      try {
    ivjNewerThanDialog = new Dialog(frame);
    ivjNewerThanDialog.setName("NewerThanDialog");
    ivjNewerThanDialog.setLayout(null);
    ivjNewerThanDialog.setModal(true);
    ivjNewerThanDialog.setBounds(385, 200, 426, 240);
    ivjNewerThanDialog.setTitle("Inlude files modified since");
    ivjNewerThanDialog.add(getSinceFileCheckBox(), getSinceFileCheckBox().getName());
    ivjNewerThanDialog.add(getSinceDateCheckBox(), getSinceDateCheckBox().getName());
    ivjNewerThanDialog.add(getNewerThanDialogOkButton(), getNewerThanDialogOkButton().getName());
    ivjNewerThanDialog.add(getSinceFileButton(), getSinceFileButton().getName());
    ivjNewerThanDialog.add(getSinceFileField(), getSinceFileField().getName());
    ivjNewerThanDialog.add(getSinceDateField(), getSinceDateField().getName());
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjNewerThanDialog;
  }






  /**
    * Return the ModifiedSinceCheckboxGroup property value.
    * @return CheckboxGroup
    */
  private CheckboxGroup getModifiedSinceCheckboxGroup() {
    if (ivjModifiedSinceCheckboxGroup == null) {
      try {
    ivjModifiedSinceCheckboxGroup = new CheckboxGroup();
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjModifiedSinceCheckboxGroup;
  }


  /**
    * Return the SinceDateCheckBox property value.
    * @return Checkbox
    */
  private Checkbox getSinceDateCheckBox() {
    if (ivjSinceDateCheckBox == null) {
      try {
    ivjSinceDateCheckBox = new Checkbox();
    ivjSinceDateCheckBox.setName("SinceDateCheckBox");
    ivjSinceDateCheckBox.setBounds(25, 85, 107, 27);
    ivjSinceDateCheckBox.setLabel("Since date");
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjSinceDateCheckBox;
  }

  /**
    * Return the SinceDateField property value.
    * @return TextField
    */
  private TextField getSinceDateField() {
    if (ivjSinceDateField == null) {
      try {
    ivjSinceDateField = new TextField();
    ivjSinceDateField.setName("SinceDateField");
    ivjSinceDateField.setBounds(159, 85, 125, 27);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjSinceDateField;
  }

  /**
    * Return the SinceFile property value.
    * @return FileDialog
    */
  private FileDialog getSinceFile() {
    if (ivjSinceFile == null) {
      try {
    ivjSinceFile = new FileDialog(frame);
    ivjSinceFile.setName("SinceFile");
    ivjSinceFile.setLayout(null);
    ivjSinceFile.setTitle("Since the following file last modified");
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjSinceFile;
  }

  /**
    * Return the SinceFileButton property value.
    * @return Button
    */
  private Button getSinceFileButton() {
    if (ivjSinceFileButton == null) {
      try {
    ivjSinceFileButton = new Button();
    ivjSinceFileButton.setName("SinceFileButton");
    ivjSinceFileButton.setBounds(309, 35, 77, 27);
    ivjSinceFileButton.setLabel("Browse ...");
    ivjSinceFileButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getSinceFile().show();
        getSinceFileField().setText(getSinceFile().getDirectory()+getSinceFile().getFile());
      }
    });
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjSinceFileButton;
  }

  /**
    * Return the SinceFileCheckBox property value.
    * @return Checkbox
    */
  private Checkbox getSinceFileCheckBox() {
    if (ivjSinceFileCheckBox == null) {
      try {
    ivjSinceFileCheckBox = new Checkbox();
    ivjSinceFileCheckBox.setName("SinceFileCheckBox");
    ivjSinceFileCheckBox.setBounds(25, 33, 105, 27);
    ivjSinceFileCheckBox.setLabel("Newer than file");
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjSinceFileCheckBox;
  }

  /**
    * Return the SinceFileField property value.
    * @return TextField
    */
  private TextField getSinceFileField() {
    if (ivjSinceFileField == null) {
      try {
    ivjSinceFileField = new TextField();
    ivjSinceFileField.setName("SinceFileField");
    ivjSinceFileField.setBounds(159, 33, 125, 27);
      } catch (java.lang.Throwable ivjExc) {
    handleException(ivjExc);
      }
    };
    return ivjSinceFileField;
  }


  /**
    * Called whenever the part throws an exception.
    * @param exception java.lang.Throwable
    */
  private void handleException(Throwable exception) {

    /* Uncomment the following lines to print uncaught exceptions to stdout */
    // System.out.println("--------- UNCAUGHT EXCEPTION ---------");
    // exception.printStackTrace(System.out);
  }

  /**
    * Initializes connections
    */
  private void initConnections() {
    this.addWindowListener(this);
    getNewerThanDialog().addWindowListener(this);
    getSinceFileCheckBox().addItemListener(this);
    getSinceDateCheckBox().addItemListener(this);
    getSinceFileCheckBox().setCheckboxGroup(getModifiedSinceCheckboxGroup());
    getSinceDateCheckBox().setCheckboxGroup(getModifiedSinceCheckboxGroup());
  }

  /**
    * Initialize class
    */
  private void initialize() {
    setName("SiteOutlinerUI");
    setModal(true);
    GridBagLayout gb = new GridBagLayout();
    GridBagConstraints gc = new GridBagConstraints();
    setLayout(gb);
    setSize(572, 371);
    setTitle("SiteOutliner V.0.1");

    gc.insets = new Insets(3,3,3,3);
    gc.anchor = GridBagConstraints.WEST;
    mb(this,0,0,1,1,new Label("Root Directory"), gb,gc);
    mb(this,0,1,1,1,new Label("Document Base URL"), gb,gc);
    mb(this,0,2,1,1,new Label("Only files ..."), gb,gc);
    gc.anchor = GridBagConstraints.EAST;
    mb(this,0,3,1,1,new Label("File types"), gb,gc);
    mb(this,0,4,1,1,new Label("Excluding"), gb,gc);
    mb(this,0,5,1,1,new Label("Newer than"), gb,gc);
    mb(this,0,6,1,1,new Label("Search depth"), gb,gc);

    gc.fill = GridBagConstraints.HORIZONTAL;
    gc.anchor = GridBagConstraints.WEST;
    mb(this,1,0,1,1,getRootDirectoryField(), gb,gc);
    mb(this,1,1,1,1,getDocumentBaseURLField(), gb,gc);
    mb(this,1,3,1,1,getFileTypesField(), gb,gc);
    mb(this,1,4,1,1,getExcludingField(), gb,gc);
    mb(this,1,5,1,1,getNewerThanField(), gb,gc);
    mb(this,1,6,1,1,getSearchDepthField(), gb,gc);

    mb(this,2,3,1,1,getFileTypeEntryDialogButton(), gb,gc);
    mb(this,2,4,1,1,getExcludingDialogButton(), gb,gc);
    mb(this,2,5,1,1,getNewerThanDialogButton(), gb,gc);

    mb(this,2,7,1,1,getDoItButton(), gb,gc);

    // cancel button
    ivjCancelButton = new Button();
    ivjCancelButton.setLabel("Cancel");
    ivjCancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
    canceled = true;
    dispose();
      }
    });
    mb(this,2,8,1,1,ivjCancelButton, gb,gc);

    // create error dialog
    errorDialog = new Dialog(frame,"Error");
    errorDialog.setLayout(null);
    errorDialog.setModal(true);
    errorDialog.setBounds(5, 300, 418, 134);
    errorDialogOkButton = new Button("OK");
    errorDialog.add(errorDialogOkButton);
    errorDialogOkButton.setBounds(230, 100, 60, 30);
    errorDialogOkButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
    errorDialog.dispose();
      }
    });
    errorDialogLabel = new Label();
    errorDialogLabel.setBounds(21, 22, 362, 30);
    errorDialogLabel.setAlignment(Label.CENTER);
    errorDialog.add(errorDialogLabel);
    errorDialog.addWindowListener(this);

    initConnections();
  }

  private void mb(Container p, int x, int y, int w, int h, Component c, GridBagLayout gb, GridBagConstraints gc) {
    gc.gridx = x;
    gc.gridy = y;
    gc.gridwidth = w;
    gc.gridheight = h;
    gb.setConstraints(c,gc);
    p.add(c);
  }

  /**
    * Method to handle events for the ItemListener interface.
    * @param e ItemEvent
    */
  public void itemStateChanged(ItemEvent e) {
    if ((e.getSource() == getSinceFileCheckBox()) ) {
      getSinceFileField().setEnabled(true);
    }
    if ((e.getSource() == getSinceFileCheckBox()) ) {
      getSinceFileButton().setEnabled(true);
    }
    if ((e.getSource() == getSinceDateCheckBox()) ) {
      getSinceFileField().setEnabled(false);
    }
    if ((e.getSource() == getSinceDateCheckBox()) ) {
      getSinceDateField().setEnabled(true);
    }
    if ((e.getSource() == getSinceFileCheckBox()) ) {
      getSinceDateField().setEnabled(false);
    }
  }


  /**
    * This method was created by a SmartGuide.
    */
  private String concatList(String[] list) {
    String s = "";
    for (int i=0; i<list.length; i++) {
      s += (list[i] + ";");
    }
    return s;
  }


  /**
    * Method to handle events for the WindowListener interface.
    * @param e WindowEvent
    */
  public void windowActivated(WindowEvent e) {
  }

  /**
    * Method to handle events for the WindowListener interface.
    * @param e WindowEvent
    */
  public void windowClosed(WindowEvent e) {
  }

  /**
    * Method to handle events for the WindowListener interface.
    * @param e WindowEvent
    */
  public void windowClosing(WindowEvent e) {
    Object s = e.getSource();
    if (s instanceof Frame) ((Frame)s).dispose();
    if (s instanceof Dialog) ((Dialog)s).dispose();
    if (s instanceof SiteOutlinerUI) ((SiteOutlinerUI)s).dispose();
    dispose();
  }

  /**
    * Method to handle events for the WindowListener interface.
    * @param e WindowEvent
    */
  public void windowDeactivated(WindowEvent e) {
  }

  public void windowDeiconified(WindowEvent e) {
  }

  /**
    * Method to handle events for the WindowListener interface.
    * @param e WindowEvent
    */
  public void windowIconified(WindowEvent e) {
  }

  /**
    * Method to handle events for the WindowListener interface.
    * @param e WindowEvent
    */
  public void windowOpened(WindowEvent e) {
  }
}


