#
# Revision: 87 1.2 samples/SiteOutliner/makeit.ksh, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
#

#
# Make script for samples/SiteOutliner directory.
# This directory contains files which require $SWINGJAR.
#


. setupEnvVars.ksh


# local override of JAVACFLAGS to fix compiling on JDK 1.2 - Defect #347
JAVACFLAGS="-J-mx100m -d $XML4JCLASSFILESDIR"

THISDIR=samples/SiteOutliner
THISCLASSDIR=$XML4JCLASSFILESDIR/$THISDIR
SRCDIR=.

SRCFILES="
                SiteOutliner.java
                SiteOutlinerUI.java
        "

case $# in
    0)  target=all;;
    *)  target=$1;;
esac

case $target in 
    all)          javac $JAVACFLAGS $SRCFILES;
                  mesg="Finished compiling all files in $THISDIR.";;
    veryclean)    rm -f $THISCLASSDIR/*.class;
                  mesg="Finished cleanup in $THISDIR.";;
    *)            echo "Target '$target' not recognized.";
                  mesg="Finished processing '$target' in $THISDIR.";;
esac

echo $mesg
exit
