/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

/*
 * Revision:  98 1.1 samples/XJParse/NSFormatPrintVisitor.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 */
 

package samples.XJParse;

import com.ibm.xml.parser.*;
import org.w3c.dom.Node;
import java.io.Writer;


public class NSFormatPrintVisitor extends FormatPrintVisitor {

    /**
     * Constructor for customized encoding and indent.
     * @param writer        The character output stream to use.
     * @param encoding      Java character encoding in use by <VAR>writer</VAR>.
     * @param indent        Number of spaces to indent at each nesting level.
     */
    public NSFormatPrintVisitor(Writer writer, String encoding, int indent) {
        super(writer, encoding, indent);
    }

    /**
     * Constructor for customized encoding.
     * @param writer        The character output stream to use.
     * @param encoding      Java character encoding in use by <VAR>writer</VAR>.
     */
    public NSFormatPrintVisitor(Writer writer, String encoding) {
        super(writer, encoding);
    }

    /**
     * Constructor for default encoding.
     * @param writer  The character output stream to use.
     */
    public NSFormatPrintVisitor(Writer writer) {
        super(writer);
    }

    /**
     * Creates a string representation of the start of the specified <var>element</var> Node
     * and its associated attributes in XML format.
     * @param   element     Node toString in XML format.
     * @exception Exception   Thrown if this Node can not be visitted because of an invalid character output stream.
     * @see com.ibm.xml.parser.TXElement
     */
    public void visitElementPre(TXElement element) throws Exception {
        if (!this.ispreserve && !this.isprevtext)  Util.indent(this.writer, this.currentIndent);
        
        
        //super.visitElementPre(element);
        this.writer.write("<" + element.createExpandedName());
        TXAttribute[] attributes = element.getAttributeArray();
        for (int i = 0;  i < attributes.length;  i ++) {
            try {
                TXAttribute attr = attributes[i];
                if (this.isPrintNonSpecifiedAttributes || attr.getSpecified())
                    visitAttributePre(attr);
            } catch (ToNextSiblingTraversalException e) {
                                                // Ignore
            }
        }
        if (element.hasChildNodes()) {
            this.writer.write(">");
        } else {
            this.writer.write("/>");
        }
        
        
        
        this.currentIndent += this.indent;
        if (element.hasChildNodes()) {
            Child ch = (Child)element.getFirstChild();
            this.preserves.push(new Boolean(this.ispreserve));
            if (1 == element.getChildNodes().getLength() && /* TXText.isText(ch) */ 
                                                ch.getNodeType() == Node.TEXT_NODE) {
                this.ispreserve = true;
            } else {
                this.ispreserve = element.isPreserveSpace();
            }
        }
        this.isprevtext = false;
    }



    /**
     * Creates a formatted string representation of the end of the specified <var>element</var> Node
     * in XML format, and directs it to the print writer.
     * @param   element         Node to print with format.
     * @exception Exception     Thrown if this Node can not be visitted because of an invalid character output stream.
     * @see com.ibm.xml.parser.TXElement
     */
    public void visitElementPost(TXElement element) throws Exception {
        this.currentIndent -= this.indent;
        if (element.hasChildNodes()) {
            if (!this.ispreserve && !this.isprevtext)  
                Util.indent(this.writer, this.currentIndent);
            this.writer.write("</");
            // this.writer.write(element.getTagName());
            this.writer.write(element.createExpandedName());
            this.writer.write(">");
            this.ispreserve = ((Boolean)this.preserves.pop()).booleanValue();
        }
        this.isprevtext = false;
    }


    /**
     * Creates a string representation of the specified <var>attribute</var> Node in XML
     * format.
     * <p>Note that TXAttribute Nodes are not parsed into the document object hierarchy by the
     * XML4J parser; attributes exist as part of a TXElement Node.
     * @param   attribute   Node toString in XML format.
     * @exception Exception   Thrown if this Node can not be visitted because of an invalid character output stream.
     * @exception com.ibm.xml.parser.ToNextSiblingTraversalException Always thrown.
     * @see com.ibm.xml.parser.TXAttribute
     */
    public void visitAttributePre(TXAttribute attribute) throws Exception {
        this.writer.write(" ");
        // this.writer.write(attribute.getName());
        this.writer.write(attribute.createExpandedName());
        this.writer.write("=\"");
        for (Node child = attribute.getFirstChild();  child != null;
             child = child.getNextSibling()) {
            int type = child.getNodeType();
            if (type == Node.TEXT_NODE) {
                this.writer.write(Util.backReference(child.getNodeValue(), "<&\"", this.encoding));
            } else if (type == Node.ENTITY_REFERENCE_NODE) {
                this.writer.write("&");
                this.writer.write(child.getNodeName());
                this.writer.write(";");
            } else {
                //???
            }
        }
        this.writer.write("\"");

        throw new ToNextSiblingTraversalException();
    }

}
