/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
package samples.XMLTreeViewer;

import java.util.Hashtable;
import com.ibm.xml.parser.ErrorListener;
import org.w3c.dom.Node;

/**
 * The ErrorFlagger maps Nodes to errors. It receives a reference
 * to the ErrorTreeFactory in the Constructor. 
 *
 * When error is called, it asks the
 * ErrorTreeFactory for the current node, and uses this as the 
 * "key" of a Hashtable, with the error as a value. The error
 * value is wrapped up nicely in an ErrorInParsing object.
 *
 * It is used in the XML Tutorial to illustrate how to implement
 * the ErrorListener to provide error storage for later reference.
 *
 * @version Revision: 05 1.1 samples/XMLTreeViewer/ErrorFlagger.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author PFEIFFER Ralf &lt;rpfeiffe@us.ibm.com&gt;
 * @see ErrorTreeFactory
 * @see ErrorInParsing
 */
public class ErrorFlagger implements ErrorListener {

    //
    // Data
    //
    Hashtable errorNodes = new Hashtable();
    Object previous;
    StringBuffer errorString;
    ErrorTreeFactory errorTreeFactory;

    /**
     * Constructor
     */
    public ErrorFlagger(ErrorTreeFactory errorTreeFactory) {
        
        this.errorTreeFactory = errorTreeFactory;
    }

    /**
     * Override error to hook into error handling, and build
     * a Hashtable mapping errors (ErrorInParsing) to Nodes.
     */
    public int error(String fileName, int lineNo, int charOffset,
                   Object key, String msg) {
                    
        errorString = new StringBuffer();
        errorString.append("at line number, ");
        errorString.append(lineNo);
        errorString.append(": ");
        errorString.append(msg);

        Node current = errorTreeFactory.getCurrentNode();
        previous = errorNodes.get(current);
        // if a Node already has an error, we accumulate the text here...
        if (previous != null) {
            errorString = new StringBuffer(((ErrorInParsing)previous).getMsg()
                                                +"\n"+errorString.toString());
        }
        // wrap it up nicely.
        ErrorInParsing eip = new
            ErrorInParsing( fileName,  lineNo,  charOffset,
                        key,  errorString.toString());
                        
        // put it in the Hasttable.
        errorNodes.put(current, eip);
        
        return 1;

    }


    /**
     * The client is is allowed to get a reference to the Hashtable,
     * and so could corrupt it, or add to it...
     */
    public Hashtable getErrorNodes() {
        return errorNodes;
    }
 
    /**
     * The ErrorInParsing object for the node key is returned. 
     * If the node doesn't have errors, null is returned.
     */
    public Object getError(Node node) {
        return errorNodes.get(node);
    }

}
