/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
 
package samples.XMLTreeViewer;

/**
 * The ErrorInParsing class wraps up all the error info from
 * the ErrorFlagger's error method.
 *
 * @version Revision: 06 1.1 samples/XMLTreeViewer/ErrorInParsing.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author PFEIFFER Ralf &lt;rpfeiffe@us.ibm.com&gt;
 * @see ErrorFlagger
 */
public class ErrorInParsing extends Object {
    
    //
    // Data
    //
    
    String fileName;
    int lineNo;
    int charOffset;
    Object key;
    String msg;

    /**
     * Constructor
     */
    public ErrorInParsing(String fileName, int lineNo, int charOffset,
                       Object key, String msg)
    {
        this. fileName=fileName;
        this. lineNo=lineNo;
        this. charOffset=charOffset;
        this. key=key;
        this. msg=msg;
    }

    //
    // Getters...
    //
    public String getFileName() { return fileName; }
    public int getLineNo() { return lineNo; }
    public int getCharOffset() { return charOffset;}
    public Object getKey() { return key; }
    public String getMsg() { return msg; }
}
