/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.XMLTreeViewer;

import com.ibm.xml.parser.*;
import com.ibm.xml.parser.util.TreeFactory;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/**
 * This is a subclass of the TreeFactory provided with the XML4J parser.
 *
 * It is used in the XML Tutorial to illustrate how to subclass the TreeFactory
 * to provide the additional functionality of accessing the "current node".
 *
 * It is used by the ErrorFlagger class, so the ErrorFlagger can map Nodes
 * to errors.
 *
 * @version Revision: 07 1.2 samples/XMLTreeViewer/ErrorTreeFactory.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author PFEIFFER Ralf &lt;rpfeiffe@us.ibm.com&gt;
 * @see com.ibm.xml.parser.Parser#setElementFactory
 * @see javax.swing.JTree
 * @see javax.swing.tree.TreeNode
 */
public class ErrorTreeFactory extends TreeFactory implements TreeNode {
    //*** added a reference to the current Node being processed -
    //*** so ErrorFlagger, can ask for the current node.
    private Node current;

    /** Used by functions within this class to set the cutrrent node.
     */
    private void setCurrentNode(Node node) {
        current = node;
    }

    /** Used by ErrorFlagger to ask for the current node being parsed.
     */
    public Node getCurrentNode() {
        return current;
    }

    // ================================================================
    // Factory methods
    // ================================================================

    public Element createElement(String name) {
        TXElement el = new TreeElement(name);
        setCurrentNode(el); // this sets the current node... each create method does this.
        el.setFactory(this);
        return el;
    }

    public TXText createTextNode(String data, boolean ignorable) {
        TXText te = new TreeText(data);
        setCurrentNode(te);
        te.setFactory(this);
        te.setIsIgnorableWhitespace(ignorable);
        return te;
    }
    public TXText createTextNode(char[] ac, int offset, int length, boolean ignorable) {
        TXText te = new TreeText(new String(ac, offset, length));
        setCurrentNode(te);
        te.setFactory(this);
        te.setIsIgnorableWhitespace(ignorable);
        return te;
    }

    public CDATASection createCDATASection(String data) {
        TXCDATASection cd = new TreeCDATASection(data);
        setCurrentNode(cd);
        cd.setFactory(this);
        return cd;
    }

    public Comment createComment(String data) {
        TXComment comm = new TreeComment(data);
        setCurrentNode(comm);
        comm.setFactory(this);
        return comm;
    }

    public ProcessingInstruction createProcessingInstruction(String name, String data) {
        TXPI pi = new TreePI(name, data);
        setCurrentNode(pi);
        pi.setFactory(this);
        return pi;
    }

    public StylesheetPI createStylesheetPI(String name, String data,
                                           String type, String href, String title) {
        StylesheetPI pi = new TreeStylesheetPI(name, data, type, href, title);
        setCurrentNode(pi);
        pi.setFactory(this);
        return pi;
    }

    public DTD createDTD() {
        DTD d = new TreeDTD();
        setCurrentNode(d);
        d.setFactory(this);
        return d;
    }
    public DTD createDTD(String rootname, ExternalID eid) {
        DTD d = new TreeDTD(rootname, eid);
        setCurrentNode(d);
        d.setFactory(this);
        return d;
    }
    public ElementDecl createElementDecl(String elementname, ContentModel cs) {
        ElementDecl ed = new TreeElementDecl(elementname, cs);
        setCurrentNode(ed);
       ed.setFactory(this);
        return ed;
    }

    public Attlist createAttlist(String elementname) {
        Attlist al = new TreeAttlist(elementname);
        setCurrentNode(al);
        al.setFactory(this);
        return al;
    }
    public AttDef createAttDef(String attributename) {
        AttDef ad = new TreeAttDef(attributename);
        setCurrentNode(ad);
        ad.setFactory(this);
        return ad;
    }
    public EntityDecl createEntityDecl(String name, String value, boolean parameter) {
        EntityDecl en = new TreeEntity(name, value, parameter);
        setCurrentNode(en);
        en.setFactory(this);
        return en;
    }
    public EntityDecl createEntity(String name, ExternalID eid, boolean isParameter, String ndata) {
        EntityDecl en = new TreeEntity(name, eid, isParameter, ndata);
        setCurrentNode(en);
        en.setFactory(this);
        return en;
    }
    public TXNotation createNotation(String name, ExternalID eid) {
        TXNotation no = new TreeNotation(name, eid);
        setCurrentNode(no);
        no.setFactory(this);
        return no;
    }
    public EntityReference createEntityReference(String name) {
        GeneralReference gr = new TreeGeneralReference(name);
        setCurrentNode(gr);
        gr.setFactory(this);
        return gr;
    }

    /**
     * This method isn't ElementFactory's method.
     */
    public PseudoNode createPseudoNode(String data) {
        PseudoNode pn = new TreePseudoNode(data);
        setCurrentNode(pn);
        pn.setFactory(this);
        return pn;
    }

    public String toString() {
        return ((ErrorTreeFactory)getFactory()).convertValueToText(this);
    }

}
