#
# Revision: 52 1.5 samples/makeit.ksh, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
#

#
# Make script for ../samples directory.
#


. setupEnvVars.ksh



THISDIR=samples
THISCLASSDIR=$XML4JCLASSFILESDIR/$THISDIR
SRCDIR=.


SRCFILES=""

case $# in
    0)  target=all;;
    *)  target=$1;;
esac

case $target in 
    all)          echo "Compiling all files in $THISDIR directory...";
#                 Create the $XML4JCLASSFILESDIR, if necessary.
                  if test ! -d $XML4JCLASSFILESDIR
                  then
                      mkdir $XML4JCLASSFILESDIR;
                  fi
                  mesg="Finished compiling all files in $THISDIR directory.";;
    veryclean)    echo "Cleaning up in $THISDIR directory...";
                  rm -f $THISCLASSDIR/*.class;
                  mesg="Finished cleanup in $THISDIR directory.";;
    *)            echo "Target '$target' not recognized.";
                  mesg="Finished processing '$target' in $THISDIR directory.";;
esac

for i in CdfEditor CdfView Miscellaneous ProGuide SiteOutliner XJParse XMLTreeViewer
do
    echo Building $target in directory $THISDIR/$i.
    sh -c "cd $i; ./makeit.ksh $target"
done

echo $mesg
exit
