#
# Revision: 86 1.2 scripts/cleanupApiDocs.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16  
#

echo "Cleaning up generated API Documentation..."

#
# Define the environment variables pointing to relevant directories.
#

. setupEnvVars.ksh

#
# Test to see if required environment variables have been set or not.
# Its fatal if any of them are not set, so we exit.
#
# The following variables should be set:
#     XML4JAPIDOCDIR
#

errFlg=0

if test ! -n "$XML4JAPIDOCDIR"
then
    echo "Build Error: Environment variable XML4JAPIDOCDIR is not set."
    errFlg=1
else
    echo "XML4JAPIDOCDIR=$XML4JAPIDOCDIR"
fi


if test $errFlg -eq 1
then
    echo "Aborting..."
    exit
fi


APIDOCDIR=$XML4JAPIDOCDIR

#
# Create the API documentation output directory if required.
#

if test -d $APIDOCDIR
then
    rm -rf $APIDOCDIR
fi


echo "Finished cleaning up generated API Documentation"
