#
# Revision: 90 1.5 scripts/compileAllSources.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_2 
#


. setupEnvVars.ksh


if test ! -n "$XML4JCLASSFILESDIR"
then
    echo "Build Error: Environment variable XML4JCLASSFILESDIR is not set."
    errFlg=1
else
    echo "XML4JCLASSFILESDIR=$XML4JCLASSFILESDIR"
fi


if test ! -n "$SRCDIR"
then
    echo "Build Error: Environment variable SRCDIR is not set."
    errFlg=1
else
    echo "SRCDIR=$SRCDIR"
fi


if test ! -n "$SAMPLESDIR"
then
    echo "Build Error: Environment variable SAMPLESDIR is not set."
    errFlg=1
else
    echo "SAMPLESDIR=$SAMPLESDIR"
fi


if test ! -n "$TUTORIALDIR"
then
    echo "Build Error: Environment variable TUTORIALDIR is not set."
    errFlg=1
else
    echo "TUTORIALDIR=$TUTORIALDIR"
fi


if test ! -n "$TESTSRCDIR"
then
    echo "Build Error: Environment variable TESTSRCDIR is not set."
    errFlg=1
else
    echo "TESTSRCDIR=$TESTSRCDIR"
fi


case $# in
    0)  target=all;;
    *)  target=$1;;
esac


if test ! -d "$TESTSRCDIR"
then
    CHILDDIRS="$SAMPLESDIR $TUTORIALDIR"
else
    CHILDDIRS="$SAMPLESDIR $TUTORIALDIR $TESTSRCDIR"
fi

case $target in 
    all)          
#                 If required, create the directory for class files.
                  if test ! -d $XML4JCLASSFILESDIR
                  then
                      mkdir $XML4JCLASSFILESDIR;
                  fi
				  sh -c "cd $SRCDIR; makeit.ksh $target";
				  for i in $CHILDDIRS
				  do
					if test -e $i
					then
						sh -c "cd $i; makeit.ksh $target"
					fi
				  done;;

    veryclean)    sh -c "cd $SRCDIR; makeit.ksh $target";
				  for i in $CHILDDIRS
				  do
					if test -e $i
					then
						sh -c "cd $i; makeit.ksh $target"
					fi
				  done;;

    *)            echo "Target '$target' not recognized.";;
esac

exit


