#
# Revision: 93 1.8 scripts/makeApiDocs.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
#

echo "Generating API Documentation..."

#
# Define the environment variables pointing to relevant directories.
#

. setupEnvVars.ksh

#
# Test to see if required environment variables have been set or not.
# Its fatal if any of them are not set, so we exit.
#
# The following variables should be set:
#     XML4JAPIDOCDIR
#     SWINGJAR
#     JDK12BIN
#     DOCSRCDIR
#     CLASSPATH
#     XML4JVERSION
#

errFlg=0

if test ! -n "$XML4JAPIDOCDIR"
then
    echo "Build Error: Environment variable XML4JAPIDOCDIR is not set."
    errFlg=1
else
    echo "XML4JAPIDOCDIR=$XML4JAPIDOCDIR"
fi


if test ! -n "$SWINGJAR"
then
    echo "Build Error: Environment variable SWINGJAR is not set."
    errFlg=1
else
    echo "SWINGJAR=$SWINGJAR"
fi


if test ! -n "$JDK12BIN"
then
    echo "Build Error: Environment variable JDK12BIN is not set."
    errFlg=1
else
    echo "JDK12BIN=$JDK12BIN"
fi


if test ! -n "$DOCSRCDIR"
then
    echo "Build Error: Environment variable DOCSRCDIR is not set."
    errFlg=1
else
    echo "DOCSRCDIR=$DOCSRCDIR"
fi


if test ! -n "$CLASSPATH"
then
    echo "Build Error: Environment variable CLASSPATH is not set."
    errFlg=1
else
    echo "CLASSPATH=$CLASSPATH"
fi


if test ! -n "$XML4JVERSION"
then
    echo "Build Error: Environment variable XML4JVERSION is not set."
    errFlg=1
else
    echo "XML4JVERSION=$XML4JVERSION"
fi


if test $errFlg -eq 1
then
    echo "Aborting..."
    exit
else
    echo ""
fi


APIDOCDIR=$XML4JAPIDOCDIR
PACKAGES="com.ibm.xml.parser com.ibm.xml.parser.util com.ibm.xml.xpointer 
          com.ibm.xml.omake com.ibm.xml.domutil org.w3c.dom org.xml.sax org.xml.sax.helpers"


#
# Create the API documentation output directory if required.
#

if test ! -d $APIDOCDIR
then
    mkdir $APIDOCDIR
fi
if test ! -d $APIDOCDIR/images
then
    mkdir $APIDOCDIR/images
fi


#
# Now, generate the API documentation using 'javadoc'.
#

VerWithDot=`echo $XML4JVERSION | sed 's/_/./g'`
$JDK12BIN/javadoc -locale en_US -doctitle "XML Parser for Java API" \
    -windowtitle "XML Parser for Java API"\
    -header "XML Parser for Java $VerWithDot" -splitindex \
    -classpath "$CLASSPATH;$SWINGJAR" \
    -version -stylesheetfile $DOCSRCDIR/apiDocs/api.css -d $APIDOCDIR $PACKAGES

#$JDK12BIN/javadoc -J-mx100m -title "XML for Java API" -header "XML for Java $VerWithDot" \
#                  -breakindex -linkall -classpath "$CLASSPATH;$SWINGJAR" -version  \
#                  -d $APIDOCDIR $PACKAGES


#
# Tweak the API documentation file.
#

for i in `ufind $APIDOCDIR -name "*.html" -print`
do
    echo $i
    mv $i $APIDOCDIR/foo.tmp
    sed -e 's/<HEAD>/<HEAD><META http-equiv="Content-Type" content="text\/html; charset=ISO-8859-1">/g' $APIDOCDIR/foo.tmp > $i
#    sed -e 's/<head>/<HEAD><META http-equiv="Content-Type" content="text\/html; charset=ISO-8859-1"><LINK rel=stylesheet type="text\/css" href="api.css">/g' -e 's/<body bgcolor="#FFFFFF">/<BODY bgcolor="#F0F0F0" link="#800040" vlink="#8080C0" text="#000000">/g' -e 's/<a name="_top_"><\/a>/<DIV><A name="_top_"><IMG src="images\/xml4japi.gif" width=600 height=54><\/A><\/DIV>/g' $APIDOCDIR/foo.tmp > $i
    rm -f $APIDOCDIR/foo.tmp
done

# cp -p $APIDOCDIR/packages.html                $APIDOCDIR/help.html

if test -e $DOCSRCDIR/apiDocs/images/xml4japi.gif
then
    cp -p $DOCSRCDIR/apiDocs/images/xml4japi.gif  $APIDOCDIR/images
fi

#
# Obsoleted by javadoc -stylesheetfile
#
#if test -e $DOCSRCDIR/apiDocs/api.css
#then
#    cp -p $DOCSRCDIR/apiDocs/api.css              $APIDOCDIR
#fi



echo "Finished generating API Documentation."
