#
# Revision: 95 1.18 scripts/setupEnvVars.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
#

#
# This 'ksh' or 'sh' script defines all the variables necessary
# to run all the XML4J build scripts.
#
# This should be the only file that would need to be changed before
# being able to build and package XML4J.
#
# CAUTION:
#     Be careful about changing the order of defining these variables.
#     Some of the variables depend on other variables defined before them.
#



#
# First we list all the variables that would need to be customized for
# a machine. Next we define some other variables, that are required by
# build scripts (these have reasonable default values).
#


#
# The following variables MUST be customized for a particular machine,
# on which XML4J will be built.
#


#
# XML4JROOT
# Point this variable to the XML4J root directory. Inside this all XML4J
# files are stored.
#

XML4JROOT=e:/xml4j
export XML4JROOT


#
# BUILDJDKDIR
# Define this variable to point to the root directory of the JDK which
# will be used to build XML4J.
#
# Don't use JDK 1.1.6 javac because class files created by it makes a
#  problem on JDK 1.2 VM.
#

BUILDJDKDIR=e:/jdk1.1.7B
export BUILDJDKDIR


#
# JDK12BIN
# Point this variable to JDK 1.2 bin directory. 'javadoc' from this bin
# directory is used to generate the API documentation.
#
# API documentation (HTML files) is generated in XML4JAPIDOCDIR.
#

JDK12BIN=e:/jdk1.2/bin
export JDK12BIN


#
# SWINGJAR
# Point this variable to Swing 1.1 jar file. Its used to by some
# samples.  If you specified JDK 1.2 for BUILDJDKDIR, set the same
# value as XML4JROOT to SWINGJAR.
#

SWINGJAR=e:/xml/swing/swingall.jar
export SWINGJAR


#
# SERVLETJAR
# Point this variable to JSDK2.0 jar file. Its used by the tutorial.
#

SERVLETJAR=e:/xml/jsdk/lib/jsdk.jar
export SERVLETJAR


#
# CLASSPATH
# Define the CLASSPATH here for building XML4J sources.
# Note:
#   Under Unix you will have to use ':' instead of ';' to separate
#   various path to class files.
#

CLASSPATH="$XML4JROOT;$XML4JROOT/src;$SWINGJAR;$SERVLETJAR;$BUILDJDKDIR/lib/classes.zip"
export CLASSPATH



#
# *****************************************************************
# The following variables have some default values. They can be assigned
# some other values, if desired.
# *****************************************************************
#



#
# XML4JCLASSFILESDIR
# Point this variable to the directory in which all the class files will be
# stored, when sources are compiled.
#
# Note: This directory is deleted during cleanup. Do not store any files
#       in this directory.
#
# CAUTION:
#     Do not point this variable to the root of the source tree for
#     generating 'class' files in the same directory as the source. The
#     'cleanup' scripts will delete the directory and the sources too.
#

XML4JCLASSFILESDIR=$XML4JROOT/class
export XML4JCLASSFILESDIR


#
# JAVACFLAGS
# Define the flags that will be used to compile all the .java files.
#

JAVACFLAGS="-O -J-mx100m -d $XML4JCLASSFILESDIR"
#JAVACFLAGS="-g -deprecation -J-mx100m -d $XML4JCLASSFILESDIR"
export JAVACFLAGS


#
# XML4JVERSION
# Extract the version number from src/com/ibm/xml/parser/Version.java
# It is used in a couple of other places.
# Final definition of XML4JVERSION should look like '1_10_34'.
#

sVerLine=`grep S_VERSION $XML4JROOT/src/com/ibm/xml/parser/Version.java`
verWithDot=`echo $sVerLine | awk '{lent=length($7);print substr($7,2,lent-3);}'`
XML4JVERSION=`echo $verWithDot | sed 's/\./_/g' | sed 's/ /_/g'`


#
# ZipFile
# Define the name of the zip file to create. It contains the XML4J
# release.
#

ZipFile=xml4j_$XML4JVERSION.zip
export ZipFile


#
# TarFile
# Define the name of the tar file to create. It contains the XML4J
# release.
#

TarFile=xml4j_$XML4JVERSION.tar
export TarFile


#
# PrivateTestFilesDir
# Point this variable to the directory containing xml files for
# internal testing.
#

PrivateTestFilesDir=$XML4JROOT/privateTestFiles
export PrivateTestFilesDir


#
# JarFile
# Define the name of the jar file to create. It contains all the parser
# .class files.
#

JarFile=xml4j_$XML4JVERSION.jar
export JarFile


#
# SamplesJarFile
# Define the name of the jar file to create. It contains the .class
# files for all the samples.
#

SamplesJarFile=xml4jSamples_$XML4JVERSION.jar
export SamplesJarFile


#
# XML4JAPIDOCDIR
# Point this variable to the directory in which all the API documentation
# will be generated, using 'javadoc'. Essentially this if where all the
# generated documentation is created.
#
# Note: This directory is deleted during cleanup. Do not store any files
#       in this directory.
#
# CAUTION:
#     Do not point this variable to the root of the source tree for
#     generating the 'html' files in the same directory as the source. The
#     'cleanup' scripts will delete the directory and the sources too.
#

XML4JAPIDOCDIR=$XML4JROOT/apiDocs
export XML4JAPIDOCDIR


#
# XML4JSHIPROOTDIR
# Point this variable to the directory, in which all the files that need to
# be shipped are collected. All files included in the ZipFile are copied
# in the 'xml4j' sub-directory.
#
# Note: This directory is deleted during cleanup. Do not store any files
#       in this directory.
#

XML4JSHIPROOTDIR=$XML4JROOT/ship
export XML4JSHIPROOTDIR


#
# DOCSRCDIR
# Point this variable the documentation source directory. Files like,
# Readme.html, FAQ.html are stored in this directory.
#
# Build scripts copy these files to their appropriate locations in the
# XML4JSHIPROOTDIR directory.
#

DOCSRCDIR=$XML4JROOT/docs
export DOCSRCDIR


#
# SRCDIR
# Point this variable to XML4J source directory.
#

SRCDIR=$XML4JROOT/src
export SRCDIR
 

#
# SAMPLESDIR
# Point this variable to XML4J samples directory.
#

SAMPLESDIR=$XML4JROOT/samples
export SAMPLESDIR
 

#
# TUTORIALDIR
# Point this variable to XML4J tutorial directory.
#

TUTORIALDIR=$XML4JROOT/tutorial
export TUTORIALDIR
 

#
# TESTSRCDIR
# Point this variable to directory containing the build scripts.
#

TESTSRCDIR=$XML4JROOT/testsrc
export TESTSRCDIR
 

#
# SCRIPTSSRCDIR
# Point this variable to directory containing the build scripts.
#

SCRIPTSSRCDIR=$XML4JROOT/scripts
export SCRIPTSSRCDIR
 

#
# TestsDir
# Point this variable to the tests directory.
#

TestsDir=$XML4JROOT/tests


#
# TestResultsFile
# Point this variable to the file containing the test results.
#

TestResultsFile=$TestsDir/TestResults.txt


