/*
 * (C) Copyright IBM Corp. 1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.domutil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * This class will be removed after W3C DOM Level 2 is published.
 *
 * @version Revision: 58 1.2 src/com/ibm/xml/domutil/DOMDuplicator.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class DOMDuplicator {
    /**
     * Clone a Node over documents including child nodes.
     * This method supports <CODE>Element, Text, CDATASection, Attr,
     * ProcessingInstruction, Comment, EntityReference</CODE>.
     *
     * @param factory A factory Document of new Node.
     * @param node Source Node.
     */
    public static Node cloneNode(Document factory, Node node) {
        Node ret = null;
        switch (node.getNodeType()) {
          case Node.ELEMENT_NODE:
            ret = factory.createElement(node.getNodeName());
            NamedNodeMap nnm = node.getAttributes();
            for (int i = 0;  i < nnm.getLength();  i ++) {
                Node a = nnm.item(i);
                ((Element)ret).setAttribute(a.getNodeName(), a.getNodeValue());
            }
            break;

          case Node.TEXT_NODE:
            ret = factory.createTextNode(node.getNodeValue());
            /*
            if (ret instanceof TXText && isAllWhitespaces(ret)) {
                ((TXText)ret).setIsIgnorableWhitespace(true);
            }
            */
            break;
          case Node.CDATA_SECTION_NODE:
            ret = factory.createCDATASection(node.getNodeValue());
            break;

          case Node.ATTRIBUTE_NODE:
            ret = factory.createAttribute(node.getNodeName());
            //ret.setNodeValue(node.getNodeValue());
            break;

          case Node.PROCESSING_INSTRUCTION_NODE:
            ret = factory.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
            break;

          case Node.COMMENT_NODE:
            ret = factory.createComment(node.getNodeValue());
            break;

          case Node.ENTITY_REFERENCE_NODE:
            ret = factory.createEntityReference(node.getNodeName());
            break;

          default:
            throw new RuntimeException("Converter#cloneNode(): Internal Error:"+node.getNodeType());
        }
        if (ret != null && node.hasChildNodes()) {
            Node child = node.getFirstChild();
            while (child != null) {
                ret.insertBefore(cloneNode(factory, child), null);
                child = child.getNextSibling();
            }
        }
        return ret;
    }

    /**
     *
    private static boolean isAllWhitespaces(Node n) {
        String v = n.getNodeValue();
        for (int i = 0;  i < v.length();  i ++) {
            int ch = v.charAt(i);
            if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n')
                return false;
        }
        return true;
    }
     */
}

