#
# Revision: 98 1.8 src/com/ibm/xml/makeit.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
#

#
# Make script for com/ibm/xml directory.
#


. setupEnvVars.ksh


THISDIR=com/ibm/xml
THISCLASSDIR=$XML4JCLASSFILESDIR/$THISDIR
SRCDIR=.

SRCFILES=""

case $# in
    0)  target=all;;
    *)  target=$1;;
esac

case $target in 
    all)          mesg="Finished compiling all files in $THISDIR.";;
    veryclean)    mesg="Finished cleanup in $THISDIR.";;
    *)            echo "Target '$target' not recognized.";
                  mesg="Finished processing '$target' in $THISDIR.";;
esac

for i in parser xpointer domutil omake tester coretests
do
    if test -d $i
    then
        echo Building $target in directory $THISDIR/$i.
        sh -c "cd $i; ./makeit.ksh $target"
    else
        echo Skipping directory $THISDIR/$i.
    fi
done

echo $mesg
exit
