/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import java.util.*;

/**
 * CMLeaf provides content model support for content model nodes that are leaf node; in other
 * words, nodes which do not have associated language primitives and are not model groups.  
 * Refer to ElementDecl for an overview of the content model, and how language primitives are 
 * used to express relationships.
 *
 * @version Revision: 91 1.9 src/com/ibm/xml/parser/CMLeaf.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.ElementDecl
 * @see com.ibm.xml.parser.CMNode
 * @see com.ibm.xml.parser.CM1op
 * @see com.ibm.xml.parser.CM2op
 */
public class CMLeaf extends CMNode {

            static final long serialVersionUID = 8334965779973489245L;
            String  name        =   null;
            int     position    =   0;
            int     maxPosition =   0;

    /**
     * Constructor.
     * @param name  The name of the leaf content model node (e.g. <code>#PCDATA</code>
     * or <code><var>elementX</var></code>).
     */
    public CMLeaf(String name) {
        this.name = name;
    }

    /**
     * Returns the name of the leaf content model node (e.g. <code>#PCDATA</code> or
     * <code><var>elementX</var></code>).
     * @return          The name of the left content model node (should never be <var>null</var>).
     */
    public String getName() {
        return this.name;
    }

    /**
     * Returns the string representation of this leaf content model node.
     * Example: <code>(<var>elementX</var></code>)
     * @return          The string representation of this leaf content model node.
     */
    public String toString() {
        return this.name;
    }

    CMNode cloneNode() {
        CMLeaf cmLeaf = new CMLeaf(this.name);
        cmLeaf.position = this.position;
        cmLeaf.maxPosition = this.maxPosition;       
        return cmLeaf;
    }

    void setPosition(int position) {
        this.position = position;
    }

    int getPosition() {
        return this.position;
    }

    boolean nullable() {
        if (null == this.nullable)  this.nullable = new Boolean(false);
        return false;
    }

    BitSet firstpos() {
        if (null == this.firstPos) {
            this.firstPos = new BitSet(this.maxPosition);
            this.firstPos.set(this.position);
        }
        return this.firstPos;
    }

    BitSet lastpos() {
        if (null == this.lastPos) {
            this.lastPos = new BitSet(this.maxPosition);
            this.lastPos.set(this.position);
        }
        return this.lastPos;
    }

    void prepare(int n) {
        this.maxPosition = n;
    }

    void setFollowpos(BitSet[] fp) {
    }

    /**
     *
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof CMLeaf))  return false;
        CMLeaf cm = (CMLeaf)obj;
        return cm.getName().equals(this.getName());
    }
    
    /**
     *
     */
    public int hashCode() {
        return this.getName().hashCode();
    }
    
}
