/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;


// See:
//  Alfred V.aho, Ravi Sethi, Jeffrey D.Ullman,
// ``Compilers Principles, Techniques, and Tools''
// Section 3.9 From a Regular Expression to a DFA

import java.util.*;

/**
 * CMNode provides an abstract content model for use by CM1op, CM2op, and CMLeaf.  Refer to
 * ElementDecl for an overview of the content model and how relationships are expressed.
 *
 * @version Revision: 92 1.4 src/com/ibm/xml/parser/CMNode.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.ElementDecl
 * @see com.ibm.xml.parser.CM1op
 * @see com.ibm.xml.parser.CM2op
 * @see com.ibm.xml.parser.CMLeaf
 */
public abstract class CMNode implements java.io.Serializable {

            static final long serialVersionUID = -5763796053832459314L;
            BitSet  firstPos    =   null;
            BitSet  lastPos     =   null;
            BitSet  followPos   =   null;
            Boolean nullable    =   null;

    abstract CMNode cloneNode();
    abstract boolean nullable();
    abstract BitSet firstpos();
    abstract BitSet lastpos();
    abstract void prepare(int n);
    abstract void setFollowpos(BitSet[] fp);
}

