/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

/**
 * @version Revision: 60 1.2 src/com/ibm/xml/parser/EbcdicToAsciiInputStream.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 */


package com.ibm.xml.parser;

import java.io.*;

/*
 *  Once we realize (after reading the first 4 bytes of a XML file) that the encoding
 *  is EBCDIC we have to read the rest of the line using an EBCDIC reader. However, we
 *  do not yet know 'which EBCDIC encoding' to use. So we presume, that the first line
 *  will always be 'ebcdic-cp-us' <=> 'CP037' java encoding name. Using this temporary
 *  EBCDIC reader we read and parse the first line (PI instruction). The default handler
 *  for PI finds the 'encoding' attribute and calls 'XMLReader::setEncoding()' with
 *  the specified encoding name ('encoding' attribute-value). At that point we will
 *  also restore the original input stream.
 *
 *  In the process of splicing this temporary reader (whose lifetime is just to parse
 *  the first line of any EBCDIC XML file), we were losing characters. The input stream
 *  seems to have some kind of internal read-ahead. To get around this read-ahead problem,
 *  we again created yet another temporary input stream which forces all reads to be one
 *  byte long.
 */

final class EbcdicToAsciiInputStream extends InputStream
{
    private InputStreamReader  fisr = null;
    private OneCharInputStream  fOneCharIS = null;


    EbcdicToAsciiInputStream (InputStream is)
    {
        try {
            fOneCharIS = new OneCharInputStream (is);
            fisr = new InputStreamReader (fOneCharIS, "CP037");
        }
        catch (IOException e) {
            System.out.println ("Could not instantiate input stream reader with ebcdic encoding");
        }
    }

    public int read() throws IOException
    {
        int ch;
        ch = fisr.read();
        if ((ch < 0) || (ch > 127))
        {
            IOException e = new CharConversionException("invalid character");
            throw e;
        }
        return (ch);
    }

    public int read (byte[] b) throws IOException
    {
        // We should never come here.
        System.out.println ("In EbcdicToAsciiInputStream::read (byte[]) method.");
        return (0);
    }

    public int read (byte[] b, int off, int len) throws IOException
    {
        // We should never come here.
        System.out.println ("In EbcdicToAsciiInputStream::read (byte[], int, int) method.");
        return (0);
    }

} // EbcdicToAsciiInputStream 



/*
 *  Input stream which allows maximum of 1 character to be read.
 */

final class OneCharInputStream extends InputStream
{
    InputStream         fIs = null;

    
    OneCharInputStream (InputStream is)
    {
        fIs = is;
    }
    
    
    public int read() throws IOException
    {
        return (fIs.read());
    }
    

    public int read (byte b[]) throws IOException
    {
        int ch = fIs.read();
        int retval;
        
        if (ch < 0)
        {
            retval = ch;
        }
        else
        {
            b[0] = (byte) ch;
            retval = 1;
        }
        return (retval);
    }
    

    public int read (byte b[], int off, int len) throws IOException
    {
        if (len > 0)
        {
            len = 1;
        }
        return (fIs.read (b, off, len));
    }
    
} // OneCharInputStream
