/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import java.util.Hashtable;
import java.util.Enumeration;

/**
 *
 * @version Revision: 00 1.8 src/com/ibm/xml/parser/EntityPool.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
class EntityPool implements java.io.Serializable {
    
    static final long serialVersionUID = -8639077697333708869L;
    private Hashtable m_entity = new Hashtable();
    private Hashtable m_para = new Hashtable(); // parameter references
    
    EntityPool() {
    }

    boolean add(EntityDecl entity) {
        String name = entity.getNodeName();
        if (entity.isParameter()) {
            if (m_para.containsKey(name))  return false;
            m_para.put(name, entity);
        } else {
            if (m_entity.containsKey(name))  return false;
            m_entity.put(name, entity);
        }
        return true;
    }

    EntityDecl refer(String name) {
        return (EntityDecl)m_entity.get(name);
    }

    EntityDecl referPara(String name) {
        return (EntityDecl)m_para.get(name);
    }

    /**
     * Return an <CODE>Enumeration</CODE> of <CODE>EntityDecl</CODE>.
     * @see com.ibm.xml.parser.EntityDecl
     */
    Enumeration elements() {
        return m_entity.elements();
    }

    /**
     * Return an <CODE>Enumeration</CODE> of <CODE>EntityDecl</CODE> for parameter entities.
     * @see com.ibm.xml.parser.EntityDecl
     */
    Enumeration parameterEntityElements() {
        return m_para.elements();
    }

    /**
     * For DTD#getEntities();
     */
    Hashtable getEntityHash() {
        return this.m_entity;
    }
}
