/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * An interface for handling error and warning events that are recognized by the XML4J parser.
 * <p>An application may implement this interface in order to redirect and alter the
 * presentation of XML4J parser errors and exceptions.
 * <p>For example, the following code fragment listens for parser errors and suppresses
 * <b>any</b> output:
 * <pre>
 *
 *   class ErrorIgnorer implements ErrorListener {
 *     public int error(String fileName, int lineNo, int charOffset, 
 *                       Object key, String msg) {
 *      // Do nothing..in other words, suppress all notifications.
 *     return 0;
 *     }
 *   }
 *
 *   public static void main(String[] argv) {
 *     ...
 *     InputStream is = new FileInputStream(fname);
 *     Parser p = new Parser(fname, new ErrorIgnorer(), null); // Suppress any parser errors
 *     TXDocument doc = p.readStream(is);
 *     ...
 *   }
 *
 * </pre>
 *
 * @version Revision: 01 1.4 src/com/ibm/xml/parser/ErrorListener.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */

public interface ErrorListener {
    
    /**
     * Interface to be implemented in order to receive control when error and warning
     * events are recognized by the parser.    Control is transferred prior to calling any 
     * ErrorHandlers.
     * @param   fileName    Processing file name, or <var>null</var> if error or warning
     *                      occurs in a document.
     * @param   lineNo      The line number where the current document event ends, or 
     *                      <var>-1</var> if not available.  Note that this is the line 
     *                      position of the first character after the text associated with 
     *                      the document event.  Do NOT trust this value when the input 
     *                      stream includes invalid octet as its encoding.
     * @param   charOffset  The column number where the current document event ends, or
     *                      <var>-1</var> if not available.  Note that this is the column 
     *                      number of the first character after the text associated with the 
     *                      document event.  The first column in a line is position 1.  Do NOT
     *                      trust this value when the input stream includes invalid octet as its encoding.
     * @param   key         The object may be an instance of <code>String</code> or <code>Exception</code>.
     *                      When this object is <code>String</code>, this value may help 
     *                      classify <var>msg</var> as an error (begins with "E_") or warning
     *                      (begins with "W_"). See sources of <CODE>com.ibm.xml.parser.r package</CODE>.
     * @param   msg         The error or warning message.
     * @return 1 if you want to increase an error counter or a warning counter in Parser; otherwise 0.
     * @see com.ibm.xml.parser.Parser#getNumberOfErrors
     * @see com.ibm.xml.parser.Parser#getNumberOfWarnings
     * @see com.ibm.xml.parser.SAXDriver#error
     */
    public int error(String fileName, int lineNo, int charOffset, Object key, String msg);
}
