/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * InsertableElements are hash table entries used by the DTD class in order to determine
 * what kind of Element you can insert into a given index of a given Element Node
 * according to the document grammar specified by a given DTD's internal and external subset.
 * <p>Refer to DTD#getInsertableElements for usage details.
 *
 * @version Revision: 06 1.5 src/com/ibm/xml/parser/InsertableElement.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.DTD#getInsertableElements(Element, int, java.util.Hashtable)
 */
public class InsertableElement {

    /**
     * A DTD element definition name or one of the XML4J-internal names that are used
     * to track the state of the InsertableElement or AppendableElement hash table:  
     * <dl>
     * <dt><var>Element name</var></dt>
     * <dd>When this InsertableElement's <var>status</var> <code>=true</code>,
     * this <var>Element name</var> may be inserted or appended; otherwise, this 
     * <var>Element name</var> may not be inserted
     * or appended to the specified Element Node.</dd>
     * <dt><code>DTD.CM_PCDATA</code></dt>
     * <dd>When this InsertableElement's <var>status</var> <code>=true</code>,
     * a TXText Node may be inserted or appended; otherwise, a TXText node may not be inserted
     * or appended to the specified Element Node.</dd>
     * <dt><code>DTD.CM_ERROR</code></dt>
     * <dd>If this InsertableElement's <var>status</var> <code>=true</code>,
     * the <var>index</var> variable will denote the 0-based index of the first incorrect 
     * Child Node of the specified Element Node; if this InsertableElement's 
     * <var>status</var> <code>=false</code>, no error has been detected.</dd>
     * <dt><code>DTD.CM_EOC</code></dt>
     * <dd>If this InsertableElement's <var>status</var> <code>=true</code>, 
     * the specified Element Node has correct and complete contents.</dd>
     * </dl>
     */
    public String name  =   null;

    /**
     * The meaning of this variable depends on this InsertableElement's <var>name</var>:
     * <dl>
     * <dt><var>Element name</var></dt>
     * <dd>Whether <var>Element name</var> may be inserted or appended to the specified Element Node.</dd>
     * <dt><code>DTD.CM_PCDATA</code></dt>
     * <dd>Whether a TXText node may be inserted or appended to the specified Element Node.</dd>
     * <dt><code>DTD.CM_ERROR</code></dt>
     * <dd>Whether an error has been detected in parsing the children of the specified
     * Element Node.</dd>
     * <dt><code>DTD.CM_EOC</code></dt>
     * <dd>Whether correct and complete contents have been determined for the specified
     * Element Node.</dd>
     * </dl>
     */
    public boolean status   =   false;

    /**
     * When this InsertableElement's <var>name</var> is <code>DTD.CMERROR</code>, this
     * variable indicates the 0-based index of the offending Child Node of the specified
     * Element Node.  This variable has no meaning for other InsertableElement <var>name</var>s.
     */
    public int index        =   -1;

    /**
     * Constructor.
     * @param   name    Name of this InsertableElement (see variable description).
     */
    public InsertableElement(String name) {
        this(name, false);
    }
    
    /**
     * Constructor.
     * @param   name    Name of this InsertableElement (see variable description).
     * @param   status  Status of this InsertableELement (see variable description).
     */
    public InsertableElement(String name, boolean status) {
        this.name   = name;
        this.status = status;
        this.index  = -1;
    }

    /**
     * Constructor for <code>DTD.CM_ERROR</code> InsertableElements.
     * @param   index   0-based index of offending Child Node.
     */
    public InsertableElement(int index) {
        this.name   = DTD.CM_ERROR;
        this.status = true;
        this.index  = index;
    }

    /**
     * Returns this InsertableElement in XML format.  For example:
     * &quot;<code>InsertableElement[&quot;elementName&quot;, true]</code>&quot;,  and 
     * &quot;<code>InsertableElement[&quot;elementName&quot;, true, 0]</code>&quot;.
     * @return  The string representation of this InsertableElement.
     */
    public String toString() {
        return DTD.CM_ERROR.equals(name)
            ? "InsertableElement[\""+this.name+"\", "+this.status+", "+this.index+"]"
            : "InsertableElement[\""+this.name+"\", "+this.status+"]";
    }
}
    
