/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import java.io.IOException;

/**
 * XML4J parser exception which signals that the XML parser is unable to detect the encoding
 * of the input or has detected irregularities in the input such as missing byte marks.
 *
 * @version Revision: 07 1.4 src/com/ibm/xml/parser/InvalidEncodingException.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see java.io.IOException
 */
public class InvalidEncodingException extends IOException {
    
    /**
     * Constructor for exception with no detail message.
     */
    public InvalidEncodingException() {
	super();
    }

    /**
     * Constructor for exception with detail message.
     * @param msg       The detail message for the exception.
     */
    public InvalidEncodingException(String msg) {
	super(msg);
    }
}
