/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * Match is a utility class which handles namespace matching.
 *
 * @version Revision: 10 1.4 src/com/ibm/xml/parser/Match.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.Namespace
 * @see com.ibm.xml.parser.TXElement
 * @see com.ibm.xml.parser.TXAttribute
 * @see com.ibm.xml.parser.TXPI
 */
public class Match {

    // match types
    public static final int QNAME       = 0;
    public static final int NSLOCAL     = 2;
    public static final int NS          = 4;

    /**
     * Returns the first <var>TXElement</var> match through all child Element Nodes.
     * All specified input parameters must match for an element to be judged as matched (see Namespace for details).
     * Various namespace matching algorithms are supported: qualified name, local name & URI, or URI.
     * Searching is done recursively, not just for immediate Child Nodes.
     * @param   matchType           Namespace match type: <code>Match.QNAME, Match.NSLOCAL, Match.NS</code>
     * @param   uri                 When matching a URI, specify the value to match; otherwise, specify <var>null</var>.
     * @param   qNameOrLocalName    When matching a qualified name or local name, specify the value to match; otherwise, specify <var>null</var>.
     * @return                      An array of matched <var>TXElement</var> Nodes, or <var>null</var> if no matches.
     * @see com.ibm.xml.parser.Namespace
     */
    public static boolean matchName(Namespace target, int matchType,
                                    String uri, String qNameOrLocalName) {
        boolean ret = false;
        switch (matchType) {
          case QNAME:
            if (qNameOrLocalName.equals("*"))
                ret = true;
            else
                ret = target.getName().equals(qNameOrLocalName);
            break;
            /*
          case PREFIXLOCAL:
            ret = uri.equals(target.getNSPrefixName())
                && qNameOrLocalName.equals(target.getNSLocalName());
            break;
            */
          case NSLOCAL:
            ret = ((uri == null && target.getNSName() == null)
                   || uri.equals(target.getNSName()))
                && qNameOrLocalName.equals(target.getNSLocalName());
            break;
            /*
          case PREFIX:
            ret = uri.equals(target.getNSPrefixName());
            break;
            */
          case NS:
            ret = uri.equals(target.getNSName());
            break;
        }
        return ret;
    }
}
