/*
 * (C) Copyright IBM Corp. 1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.*;

/**
 * NOOPVisitor is an adapter class that implements the Visitor interface without providing
 * any operation on the various DOM- and XML4J-defined Nodes; other visitors, such as 
 * ToXMLStringVisitor, subclass NOOPVisitor and selectively override these NOOP methods to provide 
 * their function.
 *
 * @version Revision: 46 1.6 src/com/ibm/xml/parser/NOOPVisitor.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author KING Adam &lt;raking@us.ibm.com&gt;
 * @see com.ibm.xml.parser.ToXMLStringVisitor
 * @see com.ibm.xml.parser.Visitor
 * @see com.ibm.xml.parser.TreeTraversal
 * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
 */
public class NOOPVisitor extends Object implements Visitor {

    /**
     * Constructor.
     */
    public NOOPVisitor() {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXDocumentFragment Node is recognized when traversing the document object tree.
     * @param   documentFragment    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitDocumentFragmentPost
     * @see com.ibm.xml.parser.TXDocumentFragment
     */
    public void visitDocumentFragmentPre(TXDocumentFragment documentFragment) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXDocumentFragment Node is recognized when traversing the document object tree.
     * @param   documentFragment    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitDocumentFragmentPre
     * @see com.ibm.xml.parser.TXDocumentFragment
     */
    public void visitDocumentFragmentPost(TXDocumentFragment documentFragment) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXDocument Node is recognized when traversing the document object tree.
     * @param   document    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitDocumentPost
     * @see com.ibm.xml.parser.TXDocument
     */
    public void visitDocumentPre(TXDocument document) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXDocument Node is recognized when traversing the document object tree.
     * @param   document    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitDocumentPre
     * @see com.ibm.xml.parser.TXDocument
     */
    public void visitDocumentPost(TXDocument document) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXElement Node is recognized when traversing the document object tree.
     * @param   element     The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitElementPost
     * @see com.ibm.xml.parser.TXElement
     */
    public void visitElementPre(TXElement element) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXElement Node is recognized when traversing the document object tree.
     * @param   element     The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitElementPre 
     * @see com.ibm.xml.parser.TXElement
     */
    public void visitElementPost(TXElement element) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXAttribute Node is recognized when traversing the document object tree.
     * @param   attribute   The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitAttributePost
     * @see com.ibm.xml.parser.TXAttribute
     */
    public void visitAttributePre(TXAttribute attribute) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXAttribute Node is recognized when traversing the document object tree.
     * @param   attribute   The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitAttributePre 
     * @see com.ibm.xml.parser.TXAttribute
     */
    public void visitAttributePost(TXAttribute attribute) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXPI Node is recognized when traversing the document object tree.
     * @param   pi          The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitPIPost
     * @see com.ibm.xml.parser.TXPI
     */
    public void visitPIPre(TXPI pi) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXPI Node is recognized when traversing the document object tree.
     * @param   pi          The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitPIPre 
     * @see com.ibm.xml.parser.TXPI
     */
    public void visitPIPost(TXPI pi) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXComment Node is recognized when traversing the document object tree.
     * @param   comment     The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitCommentPost
     * @see com.ibm.xml.parser.TXComment
     */
    public void visitCommentPre(TXComment comment) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXComment Node is recognized when traversing the document object tree.
     * @param   comment     The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitCommentPre
     * @see com.ibm.xml.parser.TXComment
     */
    public void visitCommentPost(TXComment comment) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXText Node is recognized when traversing the document object tree.
     * @param   text        The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitTextPost
     * @see com.ibm.xml.parser.TXText
     */
    public void visitTextPre(TXText text) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXText Node is recognized when traversing the document object tree.
     * @param   text        The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitTextPre 
     * @see com.ibm.xml.parser.TXText
     */
    public void visitTextPost(TXText text) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a DTD Node is recognized when traversing the document object tree.
     * @param   dtd         The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitDTDPost
     * @see com.ibm.xml.parser.DTD
     */
    public void visitDTDPre(DTD dtd) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a DTD Node is recognized when traversing the document object tree.
     * @param   dtd         The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitDTDPre 
     * @see com.ibm.xml.parser.DTD
     */
    public void visitDTDPost(DTD dtd) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * an ElementDecl Node is recognized when traversing the document object tree.
     * @param   elementDecl The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitElementDeclPost
     * @see com.ibm.xml.parser.ElementDecl
     */
    public void visitElementDeclPre(ElementDecl elementDecl) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * an ElementDecl Node is recognized when traversing the document object tree.
     * @param   elementDecl The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitElementDeclPre
     * @see com.ibm.xml.parser.ElementDecl
     */
    public void visitElementDeclPost(ElementDecl elementDecl) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * an Attlist Node is recognized when traversing the document object tree.
     * @param   attlist     The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitAttlistPost
     * @see com.ibm.xml.parser.Attlist
     */
    public void visitAttlistPre(Attlist attlist) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * an Attlist Node is recognized when traversing the document object tree.
     * @param   attlist     The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitAttlistPre 
     * @see com.ibm.xml.parser.Attlist
     */
    public void visitAttlistPost(Attlist attlist) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * an AttDef Node is recognized when traversing the document object tree.
     * @param   attDef      The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitAttDefPost
     * @see com.ibm.xml.parser.AttDef 
     */
    public void visitAttDefPre(AttDef attDef) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * an AttDef Node is recognized when traversing the document object tree.
     * @param   attDef      The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitAttDefPre 
     * @see com.ibm.xml.parser.AttDef 
     */
    public void visitAttDefPost(AttDef attDef) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * an EntityDecl Node is recognized when traversing the document object tree.
     * @param   entityDecl      The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitEntityDeclPost
     * @see com.ibm.xml.parser.EntityDecl
     */
    public void visitEntityDeclPre(EntityDecl entityDecl) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * an EntityDecl Node is recognized when traversing the document object tree.
     * @param   entityDecl      The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitEntityDeclPre 
     * @see com.ibm.xml.parser.EntityDecl
     */
    public void visitEntityDeclPost(EntityDecl entityDecl) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a TXNotation Node is recognized when traversing the document object tree.
     * @param   notation    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitNotationPost
     * @see com.ibm.xml.parser.TXNotation
     */
    public void visitNotationPre(TXNotation notation) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a TXNotation Node is recognized when traversing the document object tree.
     * @param   notation    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitNotationPre 
     * @see com.ibm.xml.parser.TXNotation
     */
    public void visitNotationPost(TXNotation notation) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a GeneralReference Node is recognized when traversing the document object tree.
     * @param   generalReference    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitGeneralReferencePost
     * @see com.ibm.xml.parser.GeneralReference
     */
    public void visitGeneralReferencePre(GeneralReference generalReference) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a GeneralReference Node is recognized when traversing the document object tree.
     * @param   generalReference    The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitGeneralReferencePre 
     * @see com.ibm.xml.parser.GeneralReference
     */
    public void visitGeneralReferencePost(GeneralReference generalReference) throws Exception {
    }

    /**
     * Subclass this method to receive control when the start of
     * a PseudoNode is recognized when traversing the document object tree.
     * @param   pseudoNode  The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitPseudoNodePost
     * @see com.ibm.xml.parser.PseudoNode
     */
    public void visitPseudoNodePre(PseudoNode pseudoNode) throws Exception {
    }

    /**
     * Subclass this method to receive control when the end of
     * a PseudoNode is recognized when traversing the document object tree.
     * @param   pseudoNode  The Node currently being traversed.
     * @exception Exception CURRENTLY NEVER THROWN.
     * @see #visitPseudoNodePre 
     * @see com.ibm.xml.parser.PseudoNode
     */
    public void visitPseudoNodePost(PseudoNode pseudoNode) throws Exception {
    }

}
