/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * An interface for providing consistent namespace handling within the XML4J parser; this
 * interface is not intended for implementation by XML4J applications.  Refer to the 
 * TXElement, TXAttribute, and TXPI classes for sample implementations of this interface.  
 * <p>The XML4J parser does not by default enable namespace processing.  In order to enable
 * namespace processing invoke <code>Parser#setProcessNamespace(true)</code>.  Once
 * the namespace specification moves forward in the W3C, namespace processing will be
 * enabled by default.
 * <p>Applications of Extensible Markup Language [XML] contain markup defined in multiple schemas, 
 * which may have been authored independently. One motivation for this is that writing good 
 * schemas is hard, so it is beneficial to re-use parts from existing, well-designed schemas. 
 * Another is the advantage of allowing search engines or other tools to operate over a range 
 * of documents that vary in many respects but use common names for common element types. 
 * <p>These considerations require that document constructs should have universal names, whose 
 * scope extends beyond their containing document.  XML namespaces, accomplishes this.
 * <p>XML namespaces are based on the use of qualified names, which contain a single colon, 
 * separating the name into a namespace prefix and the local name. The prefix, which is 
 * mapped to a URI, selects a namespace. The combination of the universally-managed URI namespace and the 
 * local schema namespace produces names that are guaranteed universally unique.
 * <p>For example, in the namespace declaration:
 *
 * <pre>&lt;?xml:namespace ns=&quot;http://digitalSignatures.org/schema/&quot; prefix=&quot;dsig&quot; ?&gt;
 *
 * </pre>
 * <p>..the various components of the namespace are:
 * <dl>
 * <dt>Prefix name
 * <dd><CODE>xml</CODE>
 * <dt>Local name
 * <dd><CODE>namespace</CODE>
 * <dt>Qualified name
 * <dd><CODE>xml:namespace</CODE>
 * </dl>
 * <p>This namespace can later be used in the document as:
 * <pre>
 * 
 * &lt;dsig:signature?&gt;
 *
 * </pre>
 * <p>In this context, the various components of the namespace are:
 * <dl>
 * <dt>Prefix name
 * <dd><CODE>dsig</CODE>
 * <dt>Local name
 * <dd><CODE>signature</CODE>
 * <dt>Qualified name
 * <dd><CODE>dsig:signature</CODE>
 * <dt>Namespace name or URI
 * <dd><CODE>http://digitalSignatures.org/schema/</CODE>
 * <dt>Universal name
 * <dd><CODE>http://digitalSignatures.org/schema/:signature</CODE>
 * </dl>
 *
 * @version Revision: 12 1.4 src/com/ibm/xml/parser/Namespace.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.Parser#setProcessNamespace
 * @see com.ibm.xml.parser.TXElement
 * @see com.ibm.xml.parser.TXAttribute
 * @see com.ibm.xml.parser.TXPI
 */
public interface Namespace {

    /**
     * Returns the qualified name of the tag.
     * @return          The first token following the markup, or "" if no name.
     */
    public String getName();

    /**
     * Returns the local name of the Namespace.
     * @return          The Namespace local name, or <var>null</var> if no local name. 
     */
    public String getNSLocalName();
    
    /**
     * Sets the local name of the Namespace.  
     * @param   nsLocalName The Namespace local name.
     * @see #getNSLocalName
    public void setNSLocalName(String nsLocalName);
     */
    
    /**
     * Returns the Namespace URI.  
     * @return          The Namespace URI, or <var>null</var> if the tag name does not
     *                  contain a prefix name or XML4J parser namespace processing is disabled.
     * @see com.ibm.xml.parser.Parser#setProcessNamespace
     */
    public String getNSName();

    /**
     * Sets the Namespace URI.  
     * @param   nsURI   The Namespace URI, or <var>null</var> if no name.
     * @see #getNSName 
    public void setNSName(String nsURI);
     */

    /**
     * If namespace support is enabled and the tag name contains a prefix name, return a string 
     * of <CODE>getNSName()+":"+getNSLocalName()</CODE>; otherwise, return <CODE>getNSLocalName()</CODE> .
     * @return          The universal name, or <var>null</var> if the tag name does not
     *                  contain a prefix name or XML4J parser namespace processing is disabled.
     * @see #getNSName
     * @see #getNSLocalName
     * @see com.ibm.xml.parser.Parser#setProcessNamespace
     * @deprecated See createExpandedName()
     */
    public String getUniversalName();

    /**
     * Return an expanded name for this element or attribute.
     * For elements, returns <CODE>getNSName()+separator+getNSLocalName()</CODE> or <CODE>getNSLocalName()</CODE>.
     * For attributes, returns <CODE>getNSName()+separator+getNSLocalName()</CODE> or <CODE>expanded name of an element + separator + getNSLocalNae()</CODE>.
     * @see com.ibm.xml.parser.TXDocument#expandedNameSeparator
     */
    public String createExpandedName();
}

