/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * An interface for handling "no required attribute" events that are recognized by the XML4J parser.
 * A "no required attribute" event occurs when an Element is parsed and a required Attribute
 * for this Element is not seen; Attributes are declared as required as part of the internal
 * and/or external DTD declaration of the XML document.
 * <p>By default, the XML4J parser will record the missing attribute as part of its error
 * reporting, and continue.  This interface permits applications to define a default value
 * when none is provided by the DTD.
 * <p>For example, an application program may want to default the value of the <code>driver</code>
 * attribute on an XML DB query specification Element to utilize the locally installed JDBC driver.
 * In this case, the application is registered with the XML4J parser instance, prior to 
 * parsing the input stream, by using the <code>addNoRequiredAttributeHandler</code> method.  
 * Subsequently, the implemented <code>handleNoRequiredAttribute</code> method will be invoked
 * by the XML4J parser instance when the input stream is read; the implemented 
 * <code>handleNoRequiredAttribute</code> method is responsible for manipulating the child
 * objects of the passed <var>element</var>. 
 *
 * @version Revision: 14 1.5 src/com/ibm/xml/parser/NoRequiredAttributeHandler.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.Parser#addNoRequiredAttributeHandler
 */

public interface NoRequiredAttributeHandler {
    
    /**
     * Interface to be implemented for receiving control when a "no required attribute" event
     * is recognized by the XML4J parser.  A "no required attribute" event occurs when an 
     * Element is parsed and a required Attribute for this Element is not seen; Attributes 
     * are declared as required as part of the internal and/or external DTD declaration of 
     * the XML document.  Control is transferred prior to parsing any children of the
     * Element that is missing the required attribute.     
     * @param element       The Element Node missing the required attribute.
     * @param attributeName The name of the missing <code>#REQUIRED</code> attribute.
     *                      Note that namespace names may also be included in Attribute names.
     * @return The modified element, or <var>null</var> if the Element is to be removed from
     *         the document.
     * @see com.ibm.xml.parser.Parser#addNoRequiredAttributeHandler
     * @see com.ibm.xml.parser.AttDef
     * @see com.ibm.xml.parser.Attlist
     * @see com.ibm.xml.parser.TXAttribute
     * @see com.ibm.xml.parser.TXAttributeList
     * @see com.ibm.xml.parser.Namespace
     */
    public TXElement handleNoRequiredAttribute(TXElement element, String attributeName);
}

