/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * An interface for receiving control when PIs are recognized by the XML4J parser.
 * <p>This interface is implemented by application programs which want to act on processing
 * instructions imbedded in XML documents.
 * <p>For example, an application program may want to resolve a PI's public ID to a locally
 * defined resource in order prevent the overhead of retrieving the external resource
 * using the system identifier.  In this case, the application is registered with the XML4J 
 * parser instance, prior to parsing the input stream, by using
 * the <code>addPIHandler</code> method.  Subsequently, the implemented <code>handlePI</code>
 * method will be invoked by the XML4J parser instance when the input stream is read; the
 * implemented <code>handlePI</code> method is responsible for manipulating the passed <var>data</var>.
 *
 * @version Revision: 18 1.3 src/com/ibm/xml/parser/PIHandler.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.Parser#addPIHandler
 */

public interface PIHandler {
    
    /**
     * Interface to be implemented for receiving control when PIs are recognized by the XML4J
     * parser.  Control is transferred after the entire PI is parsed.
     * @param name      The first token following the markup.
     * @param data      From the character immediately after <var>name</var> to the 
     *                    character immediately preceding the <code>?&gt;</code>.
     * @see com.ibm.xml.parser.TXPI
     * @see com.ibm.xml.parser.Parser#addPIHandler
     */
    public void handlePI(String name, String data);
}

