/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 *
 * @version Revision: 16 1.3 src/com/ibm/xml/parser/ParsePoint.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */

class ParsePoint implements FileScanner {
    String m_fname;
    int m_linenumber;
    int m_charlocation;
    Object m_target;

    ParsePoint(Token tok, Object o) {
        this(tok.getReading(), o);
    }
    ParsePoint(Reading rr, Object o) {
        m_fname = rr.getFileName();
        m_linenumber = rr.getLineNumber();
        m_charlocation = rr.getCharLocation();
        m_target = o;
    }
    public String getFileName() {
        return m_fname;
    }
    public int getLineNumber() {
        return m_linenumber;
    }
    public int getCharLocation() {
        return m_charlocation;
    }
    
}
