/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * An interface for receiving control from the XML4J parser after the internal and/or external
 * DTD subsets are parsed, but before the document's root Element is parsed.
 * <p>This interface is implemented by application programs which want to modify the
 * specifics of the DTD that the XML document might be validated against.
 * <p>For example, an application program may want to tune its standardized API description,
 * which is expressed in the form of a DTD, in order to accomodate platform-specific limitations.
 * In this case, the application is registered with the XML4J parser instance, prior to 
 * parsing the input stream, by using the <code>addPreRootHandler</code> method.  Subsequently, 
 * the implemented <code>handlePreRoot</code> method will be invoked by the XML4J parser 
 * instance when the input stream is read; the implemented <code>handlePreRoot</code> method 
 * is responsible for manipulating the DTD.
 *
 * @version Revision: 19 1.3 src/com/ibm/xml/parser/PreRootHandler.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.Parser#addPIHandler
 */

public interface PreRootHandler {
    
    /**
     * Interface to be implemented for receiving control after the external and/or internal
     * DTD subsets are parsed, but before the document's root Element is parsed.
     * @param   document    Root Node of this Document.
     * @param   rootName    The name of this document's DTD.  This value is also known as 
     *                      the <code>DOCTYPE</code> and the root Element Name.
     * @see com.ibm.xml.parser.Parser#addPreRootHandler
     * @see com.ibm.xml.parser.TXDocument#getDTD()
     * @see com.ibm.xml.parser.DTD
     */
    public void handlePreRoot(TXDocument document, String rootName);
}

