/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * An interface for receiving control when a General Reference is recognized by the XML4J 
 * parser.  This interface is useful to applications which are sensitive to the existence
 * of General References and want to receive control prior to and after the XML4J parser 
 * expands the General Reference in favor of its children in the document object tree.
 * <p>Refer to GeneralReference for details.
 *
 * @version Revision: 22 1.3 src/com/ibm/xml/parser/ReferenceHandler.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.GeneralReference
 */
public interface ReferenceHandler {
    
    /**
     * Interface to be implemented for receiving control when a General Reference is
     * recognized by the XML4J parser.  Control is received prior to parsing any entity
     * streams.
     * @param   entityName  The name of the entity being referred to by the General Reference.
     * @see #endReference
     * @see com.ibm.xml.parser.GeneralReference
     */
    public void startReference(String entityName);

    /**
     * Interface to be implemented for receiving control after all entity streams for a
     * General Reference have been parsed.
     * @param   entityName  The name of the entity being referred to by the General Reference.
     * @see #startReference
     * @see com.ibm.xml.parser.GeneralReference
     */
    public void endReference(String entityName);
}
