/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import java.io.InputStream;
import java.io.Reader;

/**
 * Source is a data object that encapsulates whether a data source is byte-stream-oriented 
 * (InputStream) or character-stream-oriented (Reader). 
 *
 * @version Revision: 24 1.5 src/com/ibm/xml/parser/Source.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see java.io.InputStream
 * @see java.io.Reader
 */
public class Source {
            InputStream inputStream =   null;
            Reader      reader      =   null;
	        String      encoding    =   null;

    /**
     * Constructor for byte-stream-oriented data.
     * @param   inputStream Byte-stream-oriented data source.
     */
    public Source(InputStream inputStream) {
        this.inputStream = inputStream;
    }
    
    /**
     * Constructor for byte-stream-oriented data.
     * @param   inputStream Byte-stream-oriented data source.
     * @param   encoding    Java character encoding to use, or <var>null</var>.
     * @see #getEncoding
     */
    public Source(InputStream inputStream, String encoding) {
        this.inputStream = inputStream;
        this.encoding    = encoding;
    }
    
    /**
     * Constructor for character-stream-oriented data.
     * @param   reader      Character-stream-oriented data source.
     */
    public Source(Reader reader) {
        this.reader = reader;
    }
    
    /**
     * Returns the byte-stream-oriented data source.
     * @return              Byte-stream-oriented data source.
     * @see #getReader
     */
    public InputStream getInputStream() {
        return this.inputStream;
    }
    
    /**
     * Returns the Java character encoding in use for the <var>inputStream</var>.  This
     * value has no meaning when the source is character-stream-oriented.
     * @return  Java encoding in use by the byte-stream-oriented source, or <var>null</var>
     *          if not specified.
     */
    public String getEncoding() {
        return this.encoding;
    }
    
    /**
     * Returns the character-stream-oriented data source.
     * @return              Character-stream-oriented data source.
     * @see #getInputStream
     */
    public Reader getReader() {
        return this.reader;
    }
}

