/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import java.io.IOException;
import java.io.Reader;

/**
 * An interface to be implemented in order to define the mechanisms for manipulating input 
 * streams.  Typical sources of input streams include character streams, a byte streams, or 
 * URIs.
 * @version Revision: 26 1.4 src/com/ibm/xml/parser/StreamProducer.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */

public interface StreamProducer {

   /**
     * Interface to be implemented in order to return the source of the input stream (could 
     * be a character stream, a byte stream, or a URI) based on the entity specified by the 
     * system ID and/or public ID.
     * @param   name        The name to be associated with the input stream.  For example, 
     *                      this name could be the public ID of an external ID, or a local filename.
     * @param   publicID    Entity's public ID (see ExternalID for details).
     * @param   systemID    Entity's system ID (see ExternalID for details).
     * @return              The resolved source of the input stream.
     * @exception java.io.IOException Thrown if unable to resolve the source of the input stream.
     * @see com.ibm.xml.parser.ExternalID
     * @see #closeInputStream
     * @see com.ibm.xml.parser.Parser#getInputStream
     * @see com.ibm.xml.parser.SAXDriver#getInputStream
     */
    public Source getInputStream(String name, String publicID, String systemID) throws IOException;

   /**
     * Interface to be implemented in order to remove the input stream currently in use.
     * @param   source      Source of the input stream to be closed.
     * @see #getInputStream
     * @see com.ibm.xml.parser.Parser#getInputStream
     * @see com.ibm.xml.parser.SAXDriver#getInputStream
     */
    public void closeInputStream(Source source);

    /**
     * Loads a catalog which provides mapping between public IDs and system IDs.
     * @param       reader      Character input stream reader.
     * @exception   IOException Thrown if <var>reader</var> is invalid.
     * @see #getInputStream
     * @see com.ibm.xml.parser.ExternalID
     * @see com.ibm.xml.parser.Parser#loadCatalog
     * @see com.ibm.xml.parser.Stderr#loadCatalog
     */
    public void loadCatalog(Reader reader) throws IOException;
}
