/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

class StringPool {
    private String[]   table;
    private int        numEntries = 0;
    static private int primes[] = {997, 2749, 7001, 24317, 399383, 15484279};
    private int        primeIndex = 0;

    StringPool() {
        table = new String[primes[0]];
    }


    String createString(char[] name, int len) {
        int     initialHash = 0;
        int     hash = 0;
        boolean found = false;
        String  s;

        for (int i=0; i<len; i++)
            initialHash += initialHash*37 + name[i];
        initialHash = (initialHash & 0x7fffffff) % table.length;
        if (initialHash == 0)
            initialHash = 1;

        do  {
            hash = (hash + initialHash) % table.length;
            s = table[hash];
            if (s == null) {
                s = new String(name, 0, len);
                table[hash] = s;
                numEntries++;
                if (numEntries*10 > table.length*8)
                    expandTable();
                return s;
            }
            if (s.length() != len)
                continue;
            found = true;
            for (int i=0; i<len; i++) {
                if (s.charAt(i) != name[i]) {
                    found = false;
                    break;
                    };
            }
         } while(! found);
         return s;
     }
     

    void reset() {
        for (int i=0; i<table.length; i++)
            table[i] = null;
    };
    
    
    private void expandTable() {
        this.primeIndex++;
        if (this.primeIndex >= this.primes.length) {
            // Do what?
        }

        String newTable[] = new String[this.primes[primeIndex]];
        for (int i = 0; i < this.primes[primeIndex-1];  i++) {
            String str = this.table[i];
            if (str != null) {
                int initialHash = 0;
                for (int cp = 0;  cp < str.length();  cp ++)
                    initialHash += initialHash*37 + str.charAt(cp);
                initialHash = (initialHash & 0x7fffffff) % newTable.length;
                if (initialHash == 0)
                    initialHash = 1;

                int hash = 0;
                String s;
                boolean found = false;
                do  {
                    hash = (hash + initialHash) % newTable.length;
                    s = newTable[hash];
                    if (s == null) {
                        newTable[hash] = str;
                        found = true;
                    }
                } while (!found);
            }
        }
        this.table = newTable;
    }
}

