/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 *
 * @version Revision: 27 1.7 src/com/ibm/xml/parser/StringReading.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
final class StringReading implements Reading {
    int m_nextchar = -1;
    Reading m_nextr = null;
    private String m_content;
    private int m_index = 0;

    StringReading(String str) {
        m_content = str;
        m_nextchar = read();
    }

    int position = Token.ST_NORMAL;
    int state = 0;
    int paren = 0;
    /*
    int firstchar = -1;
    int lastchar = -1;
    */
    boolean ltgt = false;

    private int read() {
        if (null == m_content || m_index >= m_content.length())
            return -1;
        int ch = m_content.charAt(m_index++);
        return ch;
    }

    public void close() throws IOException {
    }
    public void setEncoding(String enc, boolean allowj) throws UnsupportedEncodingException {
    }


    public int getChar() throws IOException {
        int ch = m_nextchar;
//        if (ch < 0) return ch;
        m_nextchar = read();
        if (this.position != Token.ST_NORMAL && this.position != Token.ST_VALUE) {
            if (this.position == Token.ST_INTERNALDTD || this.position == Token.ST_EXTERNALDTD) {
                if (this.state != 0) {
                    if (this.state == ch)
                        this.state = 0;
                } else if (ch == '<') {
                    this.paren ++;
                } else if (ch == '>') {
                    this.paren --;
                } else if (ch == '"' || ch == '\'') {
                    this.state = ch;
                }
            } else {                            // ST_TAG or ST_CONTENTMODEL
                /*
                if (!XMLChar.isSpace(ch)) {
                    if (this.firstchar < 0)  this.firstchar = ch;
                    this.lastchar = ch;
                }
                */
                if (this.state != 0) {
                    if (this.state == ch)
                        this.state = 0;
                } else if (ch == '(') {
                    this.paren ++;
                } else if (ch == ')') {
                    this.paren --;
                } else if (ch == '>' || ch == '<') {
                    this.ltgt = true;
                } else if (ch == '"' || ch == '\'') {
                    this.state = ch;
                }
            }
        }
        return ch;
    }
    public String getFileName() {
        return null == m_nextr ? "(null?)" : m_nextr.getFileName();
    }
    public int getLineNumber() {
        return null == m_nextr ? -1 : m_nextr.getLineNumber();
    }
    public int getCharLocation() {
        return null == m_nextr ? -1 : m_nextr.getCharLocation();
    }
    public void setNext(Reading r) {
        m_nextr = r;
    }
    public Reading getNext() {
        return m_nextr;
    }
    public int readNext() {
        return m_nextchar;
    }
    public void setChecking(int status) {
        this.position = status;
    }
    public String getErrorKey() {
        String ret = null;
        if (this.ltgt) {
            ret = "V_PEREF9";
        } else if (this.paren != 0 && this.position == Token.ST_CONTENTMODEL) {
            ret = "V_PEREF7";
        } else if (this.paren != 0) {
            ret = "V_PEREF9";
            /*
        } else if (this.position == Token.ST_CONTENTMODEL
                   && (this.firstchar == '|' || this.firstchar == ','
                       || this.lastchar == '|' || this.lastchar == ',')) {
            ret = "E_PEREF8";
        } else if (this.position == Token.ST_CONTENTMODEL
                   && this.m_content.length() == 2) {
            ret = "E_PEREF6";
            */
        }
        return ret;
    }
}
