/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import org.w3c.dom.Node;
import org.w3c.dom.CDATASection;

/**
 * The TXCDATASection class implements the CDATASection interface as defined by the Document Object Model (DOM).
 * <p>CDATA sections are Text Node extensions that are used to provide a region in which most of the XML delimiter 
 * recognition does not take place. The primary purpose is for including material such as XML fragments, without 
 * needing to escape all the delimiters.
 * <p>An example of a CDATA section in which <CODE>&lt;greeting&gt;</CODE> and <CODE>&lt;/greeting&gt;</CODE>
 * are recognized as character data and not markup is:
 * <CENTER><CODE>&lt;![CDATA[&lt;greeting&gt;Hello, world!&lt;/greeting&gt;]]&gt;</CODE></CENTER>
 *
 * @version Revision: 33 1.9 src/com/ibm/xml/parser/TXCDATASection.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.parser.TXText
 * @see org.w3c.dom.CDATASection
 */
public class TXCDATASection extends TXText implements CDATASection {
    
    static final long serialVersionUID = 8068656725170937194L;
    /**
     * Constructor.
     * @param data      The actual content of the CDATASection Node.
     */
    public TXCDATASection(String data) {
        super(data);
    }

    /**
     * Clone this CDATASection using the appropriate factory.  
     * <p>This method is defined by Child.
     * @return          Cloned CDATASection.
     * @see com.ibm.xml.parser.Child#clone
     */
    public synchronized Object clone() {
        checkFactory();
        TXCDATASection cdata = (TXCDATASection)factory.createCDATASection(getText());
        cdata.setFactory(getFactory());
        return cdata;
    }

    /*
     *
     */
    public synchronized boolean equals(Node arg, boolean deep) {
        if (arg == null)  return false;
        if (!(arg instanceof CDATASection))  return false;
        CDATASection cdata = (CDATASection)arg;
        return this.getData().equals(cdata.getData());
    }

    /**
     * Returns that this object is a CDATASection Node. 
     * <p>This method is defined by DOM.
     * @return          CDATASection Node indicator.
     */
    public short getNodeType() {
        return Node.CDATA_SECTION_NODE;
    }

    /**
     *
     */
    public String getNodeName() {
        return Child.NAME_CDATA;
    }

}
