/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

/**
 * The TXComment class implements the Comment interface as defined by the Document Object Model (DOM).
 * <p>A TXComment Node represents the content of a comment, i.e. all the characters between the 
 * starting <CODE>&apos;&lt;!--&apos;</CODE> and ending <CODE>&apos;--&gt;&apos;</CODE>. 
 *
 * @version Revision: 34 1.12 src/com/ibm/xml/parser/TXComment.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see org.w3c.dom.Comment
 * @see com.ibm.xml.parser.Child
 */
public class TXComment extends TXCharacterData implements Comment {
    
    static final long serialVersionUID = 1828125899632355320L;
    /**
     * Constructor.
     * @param data      The actual content of the Comment Node.
     */
    public TXComment(String data) {
        this.data = data;
    }

    /**
     * Clone this Comment Node using the appropriate factory.  
     * <p>This method is defined by Child.
     * @return          Cloned Comment Node.
     * @see com.ibm.xml.parser.Child#clone
     */
    public synchronized Object clone() {
        checkFactory();
        TXComment comm = (TXComment)factory.createComment(this.data);
        comm.setFactory(getFactory());
        return comm;
    }

    /**
     *
     * @param deep Ignored.
     */
    public synchronized boolean equals(Node arg, boolean deep) {
        if (arg == null)  return false;
        if (!(arg instanceof Comment))  return false;
        Comment com = (Comment)arg;
        return com.getData().equals(this.getData());
    }

    /**
     * Returns that this object is a Comment Node. 
     * <p>This method is defined by DOM.
     * @return          Comment Node indicator.
     */
    public short getNodeType() {
        return Node.COMMENT_NODE;
    }

    /**
     * <p>This method is defined by DOM.
     *
     */
    public String getNodeName() {
        return Child.NAME_COMMENT;
    }

    /**
     * Return all text associated with this Node without considering entities.                                           
     * <p>This method is defined by Child.
     * @return          Always returns <var>""</var>.
     * @see com.ibm.xml.parser.Child#toXMLString
     */
    public String getText() {
        return "";
    }
    
    /**
     * Implements the accept operation of the visitor design pattern when the start of
     * a TXComment Node is recognized when traversing the document object tree. 
     * @param   visitor The implemention of the Visitor operation (toXMLString, digest, ...)
     * @exception Exception Thrown if this Node can not be visitted, or traversal modification is requested.
     * @see com.ibm.xml.parser.Visitor
     * @see com.ibm.xml.parser.TreeTraversal
     * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
     * @see com.ibm.xml.parser.TreeTraversalException
     */
    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitCommentPre(this);
    }

    /**
     * Implements the accept operation of the visitor design pattern when the end of
     * a TXComment Node is recognized when traversing the document object tree. 
     * @param   visitor The implemention of the Visitor operation (toXMLString, digest, ...)
     * @exception Exception Thrown if this Node can not be visitted, or traversal modification is requested.
     * @see com.ibm.xml.parser.Visitor
     * @see com.ibm.xml.parser.TreeTraversal
     * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
     * @see com.ibm.xml.parser.TreeTraversalException
     */
    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitCommentPost(this);
    }
}
