/*
 * (C) Copyright IBM Corp. 1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/**
 *
 * @version Revision: 41 1.5 src/com/ibm/xml/parser/TXDocumentFragment.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see org.w3c.dom.DocumentFragment
 * @see com.ibm.xml.parser.Parent
 */
public class TXDocumentFragment extends Parent implements DocumentFragment {

    static final long serialVersionUID = 6444589823666718310L;
    /**
     * Constructor.
     */
    public TXDocumentFragment() {
        super();
    }

    /**
     *
     */
    public Object clone() {
        return cloneNode(true);
    }

    /**
     *
     */
    public synchronized Node cloneNode(boolean deep) {
        checkFactory();
        TXDocumentFragment d = (TXDocumentFragment)this.getOwnerDocument().createDocumentFragment();
        d.setFactory(getFactory());
        if (deep) {
            d.children.ensureCapacity(children.getLength());
            for (int i = 0;  i < children.getLength();  i ++)
                d.appendChild(children.item(i).cloneNode(true));
        }
        return d;
    }

    /**
     *
     */
    public synchronized boolean equals(Node arg, boolean deep) {
        if (!(arg instanceof TXDocumentFragment))  return false;
        TXDocumentFragment doc = (TXDocumentFragment)arg;
        if (deep) {
            if (!doc.children.equals(this.children, deep))
                return false;
        }
        return true;
    }

    /**
     * Returns that this object is a DocumentFragment Node.
     * <p>This method is defined by DOM.
     * @return          DocumentFragment Node indicator.
     */
    public short getNodeType() {
        return Node.DOCUMENT_FRAGMENT_NODE;
    }

    /**
     * <p>This method is defined by DOM.
     *
     */
    public String getNodeName() {
        return Child.NAME_DOCFRAGMENT;
    }

    /**
     * Implements the accept operation of the visitor design pattern when the start of
     * a TXDocumentFragment Node is recognized when traversing the document object tree. 
     * @param   visitor The implemention of the Visitor operation (toXMLString, digest, ...)
     * @exception Exception Thrown if this Node can not be visitted, or traversal modification is requested.
     * @see com.ibm.xml.parser.Visitor
     * @see com.ibm.xml.parser.TreeTraversal
     * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
     * @see com.ibm.xml.parser.TreeTraversalException
     */
    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitDocumentFragmentPre(this);
    }
    /**
     * Implements the accept operation of the visitor design pattern when the end of
     * a TXDocumentFragment Node is recognized when traversing the document object tree. 
     * @param   visitor The implemention of the Visitor operation (toXMLString, digest, ...)
     * @exception Exception Thrown if this Node can not be visitted, or traversal modification is requested.
     * @see com.ibm.xml.parser.Visitor
     * @see com.ibm.xml.parser.TreeTraversal
     * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
     * @see com.ibm.xml.parser.TreeTraversalException
     */
    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitDocumentFragmentPost(this);
    }

    /**
     * Check whether <VAR>child</VAR> is allowed to be insered in this node or not.
     * When not allowed, a DOMException with HIERARCHY_REQUEST_ERR is thrown.
     */
    protected void checkChildType(Node child) throws DOMException {
        switch (child.getNodeType()) {
          case Node.ELEMENT_NODE:
          case Node.PROCESSING_INSTRUCTION_NODE:
          case Node.COMMENT_NODE:
          case Node.TEXT_NODE:
          case Node.CDATA_SECTION_NODE:
          case Node.ENTITY_REFERENCE_NODE:
          case Child.PSEUDONODE:
            break;
          default:
            throw new TXDOMException(DOMException.HIERARCHY_REQUEST_ERR,
                                     "Specified node type ("+child.getNodeType()
                                     +") can't be a child of DocumentFragment.");
        }
    }
}
